/*
 * Decompiled with CFR 0.152.
 */
package plugin.greenthrottle;

import android.app.Activity;
import android.content.Context;
import android.widget.Toast;
import com.ansca.corona.CoronaActivity;
import com.ansca.corona.CoronaEnvironment;
import com.ansca.corona.CoronaRuntime;
import com.ansca.corona.CoronaRuntimeListener;
import com.greenthrottle.gcs.api.ControllerEvent;
import com.greenthrottle.unifier.ControllerPlayer;
import com.greenthrottle.unifier.GreenThrottleService;
import com.naef.jnlua.JavaFunction;
import com.naef.jnlua.LuaState;
import com.naef.jnlua.NamedJavaFunction;
import java.util.ArrayList;

public class LuaLoader
implements JavaFunction,
CoronaRuntimeListener {
    private CoronaActivity m_Activity;
    public static final int BUTTON_A = 0;
    public static final int BUTTON_B = 1;
    public static final int BUTTON_Y = 2;
    public static final int BUTTON_X = 3;
    public static final int BUTTON_DOWN = 4;
    public static final int BUTTON_UP = 5;
    public static final int BUTTON_LEFT = 6;
    public static final int BUTTON_RIGHT = 7;
    public static final int BUTTON_L1 = 8;
    public static final int BUTTON_L2 = 9;
    public static final int BUTTON_L3 = 10;
    public static final int BUTTON_R1 = 11;
    public static final int BUTTON_R2 = 12;
    public static final int BUTTON_R3 = 13;
    public static final int BUTTON_ANALOG_LEFT_UP = 14;
    public static final int BUTTON_ANALOG_LEFT_DOWN = 15;
    public static final int BUTTON_ANALOG_LEFT_LEFT = 16;
    public static final int BUTTON_ANALOG_LEFT_RIGHT = 17;
    public static final int BUTTON_ANALOG_RIGHT_UP = 18;
    public static final int BUTTON_ANALOG_RIGHT_DOWN = 19;
    public static final int BUTTON_ANALOG_RIGHT_LEFT = 20;
    public static final int BUTTON_ANALOG_RIGHT_RIGHT = 21;
    public static final int BUTTON_BACK = 22;
    public static final int BUTTON_START = 23;
    public static final int BUTTON_GTHOME = 24;
    private static final int BUTTONS_COUNT = 25;
    public static final int CONTROLLER_1 = 0;
    public static final int CONTROLLER_2 = 1;
    public static final int CONTROLLER_3 = 2;
    public static final int CONTROLLER_4 = 3;
    public static final int MAX_CONTROLLERS = 4;
    public static final int BUTTON_STATE_HELD = 0;
    public static final int BUTTON_STATE_DOWN = 1;
    public static final int BUTTON_STATE_UP = 2;
    private static final int BUTTON_STATES_COUNT = 3;
    public static final int ANALOG_LEFT = 0;
    public static final int ANALOG_RIGHT = 1;
    public static final int ANALOG_L2 = 2;
    public static final int ANALOG_R2 = 3;
    private static final int ANALOG_CONTROL_COUNT = 4;
    public static final int ANALOG_AXIS_X = 0;
    public static final int ANALOG_AXIS_Y = 1;
    private static final int ANALOG_AXIS_COUNT = 2;
    private boolean[][][] buttonState = null;
    private float[][][] analogState = null;
    private boolean[][] analogChanged = null;
    private boolean[] controllerConnected = null;
    private boolean serviceConnected = false;
    private CoronaService service = null;
    public static final int STATE_BUTTON = 0;
    public static final int STATE_ANALOG = 1;
    private ArrayList<StateData> newStates = new ArrayList();

    public LuaLoader() {
        CoronaActivity activity = CoronaEnvironment.getCoronaActivity();
        if (activity == null) {
            throw new IllegalArgumentException("Activity cannot be null.");
        }
        this.m_Activity = activity;
        this.service = new CoronaService();
        this.buttonState = new boolean[3][4][25];
        this.analogState = new float[2][4][4];
        this.analogChanged = new boolean[4][4];
        this.controllerConnected = new boolean[4];
        this.service.BindService((Activity)this.m_Activity);
        this.service.addLeftRemap();
        this.service.hideSystemUI((Activity)this.m_Activity);
    }

    public int invoke(LuaState L) {
        NamedJavaFunction[] luaFunctions = new NamedJavaFunction[]{new LuaButtonState(), new LuaAnalogState(), new LuaAnalogChanged(), new LuaConnectedState(), new LuaServiceConnected(), new LuaClearControllerState(), new LuaAddLeftButtonRemap(), new LuaRemoveLeftButtonRemap(), new LuaAddRightButtonRemap(), new LuaRemoveRightButtonRemap(), new LuaHideAndroidSystemUI(), new LuaStartFrame()};
        String libName = L.toString(1);
        L.register(libName, luaFunctions);
        int index = L.getTop();
        L.pushInteger(0);
        L.setField(index, "BUTTON_A");
        L.pushInteger(1);
        L.setField(index, "BUTTON_B");
        L.pushInteger(2);
        L.setField(index, "BUTTON_Y");
        L.pushInteger(3);
        L.setField(index, "BUTTON_X");
        L.pushInteger(4);
        L.setField(index, "BUTTON_DOWN");
        L.pushInteger(5);
        L.setField(index, "BUTTON_UP");
        L.pushInteger(6);
        L.setField(index, "BUTTON_LEFT");
        L.pushInteger(7);
        L.setField(index, "BUTTON_RIGHT");
        L.pushInteger(8);
        L.setField(index, "BUTTON_L1");
        L.pushInteger(9);
        L.setField(index, "BUTTON_L2");
        L.pushInteger(10);
        L.setField(index, "BUTTON_L3");
        L.pushInteger(11);
        L.setField(index, "BUTTON_R1");
        L.pushInteger(12);
        L.setField(index, "BUTTON_R2");
        L.pushInteger(13);
        L.setField(index, "BUTTON_R3");
        L.pushInteger(14);
        L.setField(index, "BUTTON_ANALOG_LEFT_UP");
        L.pushInteger(15);
        L.setField(index, "BUTTON_ANALOG_LEFT_DOWN");
        L.pushInteger(16);
        L.setField(index, "BUTTON_ANALOG_LEFT_LEFT");
        L.pushInteger(17);
        L.setField(index, "BUTTON_ANALOG_LEFT_RIGHT");
        L.pushInteger(18);
        L.setField(index, "BUTTON_ANALOG_RIGHT_UP");
        L.pushInteger(19);
        L.setField(index, "BUTTON_ANALOG_RIGHT_DOWN");
        L.pushInteger(20);
        L.setField(index, "BUTTON_ANALOG_RIGHT_LEFT");
        L.pushInteger(21);
        L.setField(index, "BUTTON_ANALOG_RIGHT_RIGHT");
        L.pushInteger(22);
        L.setField(index, "BUTTON_BACK");
        L.pushInteger(23);
        L.setField(index, "BUTTON_START");
        L.pushInteger(24);
        L.setField(index, "BUTTON_GTHOME");
        L.pushInteger(0);
        L.setField(index, "CONTROLLER_1");
        L.pushInteger(1);
        L.setField(index, "CONTROLLER_2");
        L.pushInteger(2);
        L.setField(index, "CONTROLLER_3");
        L.pushInteger(3);
        L.setField(index, "CONTROLLER_4");
        L.pushInteger(0);
        L.setField(index, "BUTTON_STATE_HELD");
        L.pushInteger(1);
        L.setField(index, "BUTTON_STATE_DOWN");
        L.pushInteger(2);
        L.setField(index, "BUTTON_STATE_UP");
        L.pushInteger(0);
        L.setField(index, "ANALOG_LEFT");
        L.pushInteger(1);
        L.setField(index, "ANALOG_RIGHT");
        L.pushInteger(2);
        L.setField(index, "ANALOG_L2");
        L.pushInteger(3);
        L.setField(index, "ANALOG_R2");
        L.pushInteger(0);
        L.setField(index, "ANALOG_AXIS_X");
        L.pushInteger(1);
        L.setField(index, "ANALOG_AXIS_Y");
        return 1;
    }

    public void onLoaded(CoronaRuntime runtime) {
    }

    public void onStarted(CoronaRuntime runtime) {
    }

    public void onSuspended(CoronaRuntime runtime) {
    }

    public void onResumed(CoronaRuntime runtime) {
    }

    public void onExiting(CoronaRuntime runtime) {
    }

    public void AddLeftButtonRemap() {
        this.service.addLeftRemap();
    }

    public void RemoveLeftButtonRemap() {
        this.service.removeLeftRemap();
    }

    public void AddRightButtonRemap() {
        this.service.addRightRemap();
    }

    public void RemoveRightButtonRemap() {
        this.service.removeRightRemap();
    }

    public void HideAndroidSystemUI() {
        this.service.hideSystemUI((Activity)this.m_Activity);
    }

    public void ClearControllerState(int controllerId) {
        if (controllerId < 4) {
            int k;
            for (k = 0; k < 25; ++k) {
                this.buttonState[0][controllerId][k] = false;
                this.buttonState[1][controllerId][k] = false;
                this.buttonState[2][controllerId][k] = false;
            }
            for (k = 0; k < 4; ++k) {
                this.analogChanged[controllerId][k] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StartFrame() {
        for (int j = 0; j < 4; ++j) {
            int k;
            for (k = 0; k < 25; ++k) {
                this.buttonState[1][j][k] = false;
                this.buttonState[2][j][k] = false;
            }
            for (k = 0; k < 4; ++k) {
                this.analogChanged[j][k] = false;
            }
        }
        ArrayList<StateData> arrayList = this.newStates;
        synchronized (arrayList) {
            for (StateData state : this.newStates) {
                if (state.type == 0) {
                    this.buttonState[2][state.controllerId][state.controlKey] = !state.pressed;
                    this.buttonState[0][state.controllerId][state.controlKey] = state.pressed;
                    this.buttonState[1][state.controllerId][state.controlKey] = state.pressed;
                    continue;
                }
                if (state.type != 1) continue;
                this.analogState[0][state.controllerId][state.controlKey] = state.x;
                this.analogState[1][state.controllerId][state.controlKey] = state.y;
                this.analogChanged[state.controllerId][state.controlKey] = true;
            }
        }
    }

    class CoronaService
    extends GreenThrottleService {
        CoronaService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ButtonAction(ControllerPlayer player, ControllerEvent.CommonCodes code, boolean pressed) {
            int controllerId = player.getPlayerNumber() - 1;
            if (controllerId >= 4) {
                return;
            }
            int button = -1;
            switch (code) {
                case A_BUTTON: {
                    button = 0;
                    break;
                }
                case B_BUTTON: {
                    button = 1;
                    break;
                }
                case X_BUTTON: {
                    button = 3;
                    break;
                }
                case Y_BUTTON: {
                    button = 2;
                    break;
                }
                case L1_BUTTON: {
                    button = 8;
                    break;
                }
                case L2_BUTTON: {
                    button = 9;
                    break;
                }
                case L3_BUTTON: {
                    button = 10;
                    break;
                }
                case R1_BUTTON: {
                    button = 11;
                    break;
                }
                case R2_BUTTON: {
                    button = 12;
                    break;
                }
                case R3_BUTTON: {
                    button = 13;
                    break;
                }
                case BACK_BUTTON: {
                    button = 22;
                    break;
                }
                case START_BUTTON: {
                    button = 23;
                    break;
                }
                case HOME_BUTTON: {
                    button = 24;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_UP: {
                    button = 14;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_RIGHT: {
                    button = 17;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_DOWN: {
                    button = 15;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_LEFT: {
                    button = 16;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_UP: {
                    button = 18;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_RIGHT: {
                    button = 21;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_DOWN: {
                    button = 19;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_LEFT: {
                    button = 20;
                    break;
                }
                case DPAD_LEFT: {
                    button = 6;
                    break;
                }
                case DPAD_RIGHT: {
                    button = 7;
                    break;
                }
                case DPAD_UP: {
                    button = 5;
                    break;
                }
                case DPAD_DOWN: {
                    button = 4;
                }
            }
            if (button != -1) {
                StateData data = new StateData();
                data.type = 0;
                data.controllerId = controllerId;
                data.controlKey = button;
                data.pressed = pressed;
                ArrayList arrayList = LuaLoader.this.newStates;
                synchronized (arrayList) {
                    LuaLoader.this.newStates.add(data);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void AnalogEvent(ControllerPlayer player, ControllerEvent.CommonCodes code, float x, float y) {
            int controllerId = player.getPlayerNumber() - 1;
            if (controllerId >= 4) {
                return;
            }
            int analog = -1;
            switch (code) {
                case LEFT_ANALOG: {
                    analog = 0;
                    break;
                }
                case RIGHT_ANALOG: {
                    analog = 1;
                    break;
                }
                case L2_ANALOG: {
                    analog = 2;
                    y = 0.0f;
                    break;
                }
                case R2_ANALOG: {
                    analog = 3;
                    y = 0.0f;
                }
            }
            if (analog != -1) {
                StateData data = new StateData();
                data.type = 1;
                data.controllerId = controllerId;
                data.controlKey = analog;
                data.x = x;
                data.y = y;
                ArrayList arrayList = LuaLoader.this.newStates;
                synchronized (arrayList) {
                    LuaLoader.this.newStates.add(data);
                }
            }
        }

        protected void ControllerAction(ControllerPlayer player, boolean connected) {
            int controllerId = player.getPlayerNumber() - 1;
            if (controllerId >= 4) {
                return;
            }
            ((LuaLoader)LuaLoader.this).controllerConnected[controllerId] = connected;
        }

        protected void ServiceStatus(boolean isConnected) {
            if (isConnected) {
                Toast.makeText((Context)LuaLoader.this.m_Activity, (CharSequence)"GCS connected", (int)0).show();
            } else {
                Toast.makeText((Context)LuaLoader.this.m_Activity, (CharSequence)"GCS DIS-connected", (int)0).show();
            }
            LuaLoader.this.serviceConnected = isConnected;
        }
    }

    private class LuaStartFrame
    implements NamedJavaFunction {
        private LuaStartFrame() {
        }

        public String getName() {
            return "startFrame";
        }

        public int invoke(LuaState L) {
            LuaLoader.this.StartFrame();
            return 0;
        }
    }

    private class LuaHideAndroidSystemUI
    implements NamedJavaFunction {
        private LuaHideAndroidSystemUI() {
        }

        public String getName() {
            return "hideAndroidSystemUI";
        }

        public int invoke(LuaState L) {
            LuaLoader.this.HideAndroidSystemUI();
            return 0;
        }
    }

    private class LuaRemoveRightButtonRemap
    implements NamedJavaFunction {
        private LuaRemoveRightButtonRemap() {
        }

        public String getName() {
            return "removeRightButtonRemap";
        }

        public int invoke(LuaState L) {
            LuaLoader.this.RemoveRightButtonRemap();
            return 0;
        }
    }

    private class LuaAddRightButtonRemap
    implements NamedJavaFunction {
        private LuaAddRightButtonRemap() {
        }

        public String getName() {
            return "addRightButtonRemap";
        }

        public int invoke(LuaState L) {
            LuaLoader.this.AddRightButtonRemap();
            return 0;
        }
    }

    private class LuaRemoveLeftButtonRemap
    implements NamedJavaFunction {
        private LuaRemoveLeftButtonRemap() {
        }

        public String getName() {
            return "removeLeftButtonRemap";
        }

        public int invoke(LuaState L) {
            LuaLoader.this.RemoveLeftButtonRemap();
            return 0;
        }
    }

    private class LuaAddLeftButtonRemap
    implements NamedJavaFunction {
        private LuaAddLeftButtonRemap() {
        }

        public String getName() {
            return "addLeftButtonRemap";
        }

        public int invoke(LuaState L) {
            LuaLoader.this.AddLeftButtonRemap();
            return 0;
        }
    }

    private class LuaClearControllerState
    implements NamedJavaFunction {
        private LuaClearControllerState() {
        }

        public String getName() {
            return "clearControllerState";
        }

        public int invoke(LuaState L) {
            int controllerId = L.checkInteger(1);
            LuaLoader.this.ClearControllerState(controllerId);
            return 0;
        }
    }

    private class LuaServiceConnected
    implements NamedJavaFunction {
        private LuaServiceConnected() {
        }

        public String getName() {
            return "getServiceConnected";
        }

        public int invoke(LuaState L) {
            L.pushBoolean(LuaLoader.this.serviceConnected);
            return 1;
        }
    }

    private class LuaConnectedState
    implements NamedJavaFunction {
        private LuaConnectedState() {
        }

        public String getName() {
            return "getConnectedState";
        }

        public int invoke(LuaState L) {
            int controllerId = L.checkInteger(1);
            L.pushBoolean(LuaLoader.this.controllerConnected[controllerId]);
            return 1;
        }
    }

    private class LuaAnalogChanged
    implements NamedJavaFunction {
        private LuaAnalogChanged() {
        }

        public String getName() {
            return "getAnalogChanged";
        }

        public int invoke(LuaState L) {
            int controllerId = L.checkInteger(1);
            int control = L.checkInteger(2);
            L.pushBoolean(LuaLoader.this.analogChanged[controllerId][control]);
            return 1;
        }
    }

    private class LuaAnalogState
    implements NamedJavaFunction {
        private LuaAnalogState() {
        }

        public String getName() {
            return "getAnalogState";
        }

        public int invoke(LuaState L) {
            int axis = L.checkInteger(1);
            int controllerId = L.checkInteger(2);
            int control = L.checkInteger(3);
            L.pushNumber((double)LuaLoader.this.analogState[axis][controllerId][control]);
            return 1;
        }
    }

    private class LuaButtonState
    implements NamedJavaFunction {
        private LuaButtonState() {
        }

        public String getName() {
            return "getButtonState";
        }

        public int invoke(LuaState L) {
            int state = L.checkInteger(1);
            int controllerId = L.checkInteger(2);
            int button = L.checkInteger(3);
            L.pushBoolean(LuaLoader.this.buttonState[state][controllerId][button]);
            return 1;
        }
    }

    class StateData {
        int type;
        int controllerId;
        int controlKey;
        boolean pressed;
        float x;
        float y;

        StateData() {
        }
    }
}

