/* Copyright 2012 Green Throttle */

package com.greenthrottle.gcs.api;
 
import com.greenthrottle.gcs.api.ControllerEvent;
import com.greenthrottle.gcs.api.ServiceStatusEvent;
import com.greenthrottle.gcs.api.ControllerInfo;

/**
 * Receives controller events
 */
oneway interface IGTControllerCallback {

	/**
	 * Receives events related to controller connect, disconnect
	 */
	void serviceStatusUpdateEvent(in ServiceStatusEvent e);
	
	/**
	 * Receives input events as they occur on a controller
	 */
    void controllerEvent(in ControllerEvent e);
	
	/**
	 * Receives information about a controller
	 */
	void controllerInfo(in ControllerInfo[] ia);
	
	void commandAck(in String response,in String extended_response); 
}
