/*
 * Copyright (C) 2001-2012 Ideaworks3D Ltd.
 * All Rights Reserved.
 *
 * This document is protected by copyright, and contains information
 * proprietary to Ideaworks Labs.
 * This file consists of source code released by Ideaworks Labs under
 * the terms of the accompanying End User License Agreement (EULA).
 * Please do not use this program/source code before you have read the
 * EULA and have agreed to be bound by its terms.
 */
/*
 * WARNING: this is an autogenerated file and will be overwritten by
 * the extension interface script.
 */
#ifndef S3E_EXT_GREENTHROTTLE_H
#define S3E_EXT_GREENTHROTTLE_H

enum GreenThrottleButtons
{
	BUTTON_A = 0,
	BUTTON_B = 1,
	BUTTON_Y = 2,
	BUTTON_X = 3,
	BUTTON_DOWN = 4,
	BUTTON_UP = 5,
	BUTTON_LEFT = 6,
	BUTTON_RIGHT = 7,
	BUTTON_L1 = 8,
	BUTTON_L2 = 9,
	BUTTON_L3 = 10,
	BUTTON_R1 = 11,
	BUTTON_R2 = 12,
	BUTTON_R3 = 13,
	BUTTON_ANALOG_LEFT_UP = 14,
	BUTTON_ANALOG_LEFT_DOWN = 15,
	BUTTON_ANALOG_LEFT_LEFT = 16,
	BUTTON_ANALOG_LEFT_RIGHT = 17,
	BUTTON_ANALOG_RIGHT_UP = 18,
	BUTTON_ANALOG_RIGHT_DOWN = 19,
	BUTTON_ANALOG_RIGHT_LEFT = 20,
	BUTTON_ANALOG_RIGHT_RIGHT = 21,
	BUTTON_BACK = 22,
	BUTTON_START = 23,
	BUTTON_GTHOME = 24,
	BUTTONS_COUNT = 25
};

enum GreenThrottleControllers
{
	CONTROLLER_1 = 0,
	CONTROLLER_2 = 1,
	CONTROLLER_3 = 2,
	CONTROLLER_4 = 3,
	MAX_CONTROLLERS = 4
};

enum GreenThrottleButtonStates
{
	BUTTON_STATE_HELD = 0,
	BUTTON_STATE_DOWN = 1,
	BUTTON_STATE_UP = 2,
	BUTTON_STATES_COUNT = 3
};

enum GreenThrottleAnalogControls
{
	ANALOG_LEFT = 0,
	ANALOG_RIGHT = 1,
	ANALOG_L2 = 2,
	ANALOG_R2 = 3,
	ANALOG_CONTROL_COUNT = 4
};

enum GreenThrottleAnalogAxes
{
	ANALOG_AXIS_X = 0,
	ANALOG_AXIS_Y = 1,
	ANALOG_AXIS_COUNT = 2
};
// \cond HIDDEN_DEFINES
S3E_BEGIN_C_DECL
// \endcond

/**
 * Returns S3E_TRUE if the GreenThrottle extension is available.
 */
s3eBool GreenThrottleAvailable();

bool GetButtonState(int buttonState, int controllerId, int button);

float GetAnalogState(int axis, int controllerId, int analogControl);

bool GetAnalogChanged(int controllerId, int analogControl);

bool GetConnectedState(int controllerId);

bool GetServiceConnected();

void ClearControllerState(int controllerId);

void AddLeftButtonRemap();

void RemoveLeftButtonRemap();

void AddRightButtonRemap();

void RemoveRightButtonRemap();

void HideAndroidSystemUI();

void StartFrame();

S3E_END_C_DECL

#endif /* !S3E_EXT_GREENTHROTTLE_H */
