/*
 * WARNING: this is an autogenerated file and will be overwritten by
 * the extension interface script.
 */

#include "s3eExt.h"
#include "IwDebug.h"
#include "s3eDevice.h"


#include "GreenThrottle.h"

/**
 * Definitions for functions types passed to/from s3eExt interface
 */
typedef       bool(*GetButtonState_t)(int buttonState, int controllerId, int button);
typedef      float(*GetAnalogState_t)(int axis, int controllerId, int analogControl);
typedef       bool(*GetAnalogChanged_t)(int controllerId, int analogControl);
typedef       bool(*GetConnectedState_t)(int controllerId);
typedef       bool(*GetServiceConnected_t)();
typedef       void(*ClearControllerState_t)(int controllerId);
typedef       void(*AddLeftButtonRemap_t)();
typedef       void(*RemoveLeftButtonRemap_t)();
typedef       void(*AddRightButtonRemap_t)();
typedef       void(*RemoveRightButtonRemap_t)();
typedef       void(*HideAndroidSystemUI_t)();
typedef       void(*StartFrame_t)();

/**
 * struct that gets filled in by GreenThrottleRegister
 */
typedef struct GreenThrottleFuncs
{
    GetButtonState_t m_GetButtonState;
    GetAnalogState_t m_GetAnalogState;
    GetAnalogChanged_t m_GetAnalogChanged;
    GetConnectedState_t m_GetConnectedState;
    GetServiceConnected_t m_GetServiceConnected;
    ClearControllerState_t m_ClearControllerState;
    AddLeftButtonRemap_t m_AddLeftButtonRemap;
    RemoveLeftButtonRemap_t m_RemoveLeftButtonRemap;
    AddRightButtonRemap_t m_AddRightButtonRemap;
    RemoveRightButtonRemap_t m_RemoveRightButtonRemap;
    HideAndroidSystemUI_t m_HideAndroidSystemUI;
    StartFrame_t m_StartFrame;
} GreenThrottleFuncs;

static GreenThrottleFuncs g_Ext;
static bool g_GotExt = false;
static bool g_TriedExt = false;
static bool g_TriedNoMsgExt = false;

static bool _extLoad()
{
    if (!g_GotExt && !g_TriedExt)
    {
        s3eResult res = s3eExtGetHash(0xd152840c, &g_Ext, sizeof(g_Ext));
        if (res == S3E_RESULT_SUCCESS)
            g_GotExt = true;
        else
            s3eDebugAssertShow(S3E_MESSAGE_CONTINUE_STOP_IGNORE,                 "error loading extension: GreenThrottle");
            
        g_TriedExt = true;
        g_TriedNoMsgExt = true;
    }

    return g_GotExt;
}

static bool _extLoadNoMsg()
{
    if (!g_GotExt && !g_TriedNoMsgExt)
    {
        s3eResult res = s3eExtGetHash(0xd152840c, &g_Ext, sizeof(g_Ext));
        if (res == S3E_RESULT_SUCCESS)
            g_GotExt = true;
        g_TriedNoMsgExt = true;
        if (g_TriedExt)
            g_TriedExt = true;
    }

    return g_GotExt;
}

s3eBool GreenThrottleAvailable()
{
    _extLoadNoMsg();
    return g_GotExt ? S3E_TRUE : S3E_FALSE;
}

bool GetButtonState(int buttonState, int controllerId, int button)
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[0] func: GetButtonState"));

    if (!_extLoad())
        return false;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    bool ret = g_Ext.m_GetButtonState(buttonState, controllerId, button);

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return ret;
}

float GetAnalogState(int axis, int controllerId, int analogControl)
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[1] func: GetAnalogState"));

    if (!_extLoad())
        return 0;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    float ret = g_Ext.m_GetAnalogState(axis, controllerId, analogControl);

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return ret;
}

bool GetAnalogChanged(int controllerId, int analogControl)
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[2] func: GetAnalogChanged"));

    if (!_extLoad())
        return false;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    bool ret = g_Ext.m_GetAnalogChanged(controllerId, analogControl);

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return ret;
}

bool GetConnectedState(int controllerId)
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[3] func: GetConnectedState"));

    if (!_extLoad())
        return false;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    bool ret = g_Ext.m_GetConnectedState(controllerId);

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return ret;
}

bool GetServiceConnected()
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[4] func: GetServiceConnected"));

    if (!_extLoad())
        return false;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    bool ret = g_Ext.m_GetServiceConnected();

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return ret;
}

void ClearControllerState(int controllerId)
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[5] func: ClearControllerState"));

    if (!_extLoad())
        return;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    g_Ext.m_ClearControllerState(controllerId);

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return;
}

void AddLeftButtonRemap()
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[6] func: AddLeftButtonRemap"));

    if (!_extLoad())
        return;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    g_Ext.m_AddLeftButtonRemap();

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return;
}

void RemoveLeftButtonRemap()
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[7] func: RemoveLeftButtonRemap"));

    if (!_extLoad())
        return;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    g_Ext.m_RemoveLeftButtonRemap();

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return;
}

void AddRightButtonRemap()
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[8] func: AddRightButtonRemap"));

    if (!_extLoad())
        return;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    g_Ext.m_AddRightButtonRemap();

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return;
}

void RemoveRightButtonRemap()
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[9] func: RemoveRightButtonRemap"));

    if (!_extLoad())
        return;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    g_Ext.m_RemoveRightButtonRemap();

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return;
}

void HideAndroidSystemUI()
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[10] func: HideAndroidSystemUI"));

    if (!_extLoad())
        return;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    g_Ext.m_HideAndroidSystemUI();

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return;
}

void StartFrame()
{
    IwTrace(GREENTHROTTLE_VERBOSE, ("calling GreenThrottle[11] func: StartFrame"));

    if (!_extLoad())
        return;

#ifdef __mips
    // For MIPs platform we do not have asm code for stack switching 
    // implemented. So we make LoaderCallStart call manually to set GlobalLock
    s3eDeviceLoaderCallStart(S3E_TRUE, NULL);
#endif

    g_Ext.m_StartFrame();

#ifdef __mips
    s3eDeviceLoaderCallDone(S3E_TRUE, NULL);
#endif

    return;
}
