package com.greenthrottle.gcs.api;

import java.util.Set;

import android.os.Parcel;
import android.os.Parcelable;

public class ControllerInfo implements Parcelable {

	/**
	 * State of this controller.  
	 * @author matth
	 *
	 */
	public enum ControllerState
	{
		INVALID,
		/**
		 * Discovered, but not yet connected
		 */
		DISCOVERED,
		/**
		 * Connected, but not yet assigned a player_id
		 */
		CONNECTED_UNBOUND,
		/**
		 * Connected and assigned to a player_id
		 */
		CONNECTED_BOUND, 
		/**
		 * Disconnected
		 */
		DISCONNECTED
	}
	
	/**
	 * Used internally by IPC
	 */
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

	/**
	 * Used internally by IPC
	 */
	public void writeToParcel(Parcel dest, int flags) {
		// TODO Auto-generated method stub
		dest.writeString(m_btAddress);
		dest.writeString(m_name);
		dest.writeString(m_systemCommonName);
		dest.writeValue(m_state);
		dest.writeByte((byte)(m_saved ? 1 : 0));
	}

	private ControllerInfo(Parcel in)
	{
		m_btAddress = in.readString();
		m_name = in.readString();
		m_systemCommonName = in.readString();
		m_state = (ControllerState) in.readValue(ControllerState.class.getClassLoader());
		m_saved = in.readByte() == 1;
	}
	
	public ControllerInfo(String controller_bt_address,
			ControllerState initial_state) {
		m_btAddress = controller_bt_address;
		setName(controller_bt_address);	//for now, name = address. The system can always update it later
		setSysCName(null);
		setState(initial_state);
	}
	
	public ControllerInfo(String controller_bt_address,
			ControllerState initial_state, boolean saved) {
		m_btAddress = controller_bt_address;
		setName(controller_bt_address);	//for now, name = address. The system can always update it later
		setSysCName(null);
		setState(initial_state);
		m_saved = saved;
	}

	public static final Parcelable.Creator<ControllerInfo> CREATOR
	= new Parcelable.Creator<ControllerInfo>() {
		public ControllerInfo createFromParcel(Parcel in) {
			return new ControllerInfo(in);
		}

		public ControllerInfo[] newArray(int size) {
			return new ControllerInfo[size];
		}
	};
	
	/**
	 * Returns BT address of the controller
	 * @return
	 */
	public String btAddress()
	{
		return m_btAddress;
	}
	public String name()
	{
		return m_name;
	}
	public String updateName(String new_name)
	{
		String s = m_name;
		setName(new_name);
		return s;
	}
	public void setName(String new_name)
	{
		m_name = (new_name == null ? new String("") : new_name);
	}
	public boolean hasName()
	{
		if (m_name != null)
		{ 
			return m_name.isEmpty();
		}
		return false;
	}
	
	/**
	 * Returns player id assigned to controller
	 * @return
	 */
	public String sysCName()
	{
		return m_systemCommonName;
	}
	public String updateSysCName(String new_name)
	{
		String s = m_systemCommonName;
		setSysCName(new_name);
		return s;
	}
	public void setSysCName(String new_name)
	{
		m_systemCommonName = (new_name == null ? new String("") : new_name);
	}
	public boolean hasSysCName()
	{
		if (m_systemCommonName != null)
		{ 
			return !m_systemCommonName.isEmpty();
		}
		return false;
	}
	
	/**
	 * Returns connection state of the controller
	 * @return
	 */
	public ControllerState state()
	{
		return m_state;
	}
	
	/**
	 * Returns true if controller is saved for autoconnect.  Used internally.
	 * @return
	 */
	public boolean isSaved() {
		return m_saved;
	}
	
	public ControllerState updateState(ControllerState new_state)
	{
		ControllerState s = m_state;
		setState(new_state);
		return s;
	}
	public void setState(ControllerState new_state)
	{
		m_state = ( new_state == null ? ControllerState.INVALID : new_state);
	}
	
	public static boolean controllerSetContainsBtAddr(Set<ControllerInfo> controllerSet, String addr) {
		for (ControllerInfo controller : controllerSet) {
			if (controller.m_btAddress.equals(addr)) {
				return true;
			}
		}
		return false;
	}
	
	public void setPlayerLight(int number) {
		m_player_light = number;
	}
	
	public int getPlayerLight() {
		return m_player_light;
	}
	
	//----------------------------------------------------- vars
	
	String m_btAddress;
	String m_name;
	String m_systemCommonName;	//"player1 controller", etc.
	ControllerState m_state;
	Boolean m_saved = false;
	int m_player_light = 0;
}
