/*
 * Decompiled with CFR 0.152.
 */
package com.greenthrottle.marmalade;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.widget.Toast;
import com.greenthrottle.gcs.api.ControllerEvent;
import com.greenthrottle.unifier.ControllerPlayer;
import com.greenthrottle.unifier.GreenThrottleService;
import com.ideaworks3d.marmalade.LoaderActivity;
import java.util.ArrayList;

public class GTMarmaladeActivity
extends LoaderActivity {
    private static GTMarmaladeActivity m_Activity = null;
    private MarmaladeService service = null;
    public static final int BUTTON_A = 0;
    public static final int BUTTON_B = 1;
    public static final int BUTTON_Y = 2;
    public static final int BUTTON_X = 3;
    public static final int BUTTON_DOWN = 4;
    public static final int BUTTON_UP = 5;
    public static final int BUTTON_LEFT = 6;
    public static final int BUTTON_RIGHT = 7;
    public static final int BUTTON_L1 = 8;
    public static final int BUTTON_L2 = 9;
    public static final int BUTTON_L3 = 10;
    public static final int BUTTON_R1 = 11;
    public static final int BUTTON_R2 = 12;
    public static final int BUTTON_R3 = 13;
    public static final int BUTTON_ANALOG_LEFT_UP = 14;
    public static final int BUTTON_ANALOG_LEFT_DOWN = 15;
    public static final int BUTTON_ANALOG_LEFT_LEFT = 16;
    public static final int BUTTON_ANALOG_LEFT_RIGHT = 17;
    public static final int BUTTON_ANALOG_RIGHT_UP = 18;
    public static final int BUTTON_ANALOG_RIGHT_DOWN = 19;
    public static final int BUTTON_ANALOG_RIGHT_LEFT = 20;
    public static final int BUTTON_ANALOG_RIGHT_RIGHT = 21;
    public static final int BUTTON_BACK = 22;
    public static final int BUTTON_START = 23;
    public static final int BUTTON_GTHOME = 24;
    private static final int BUTTONS_COUNT = 25;
    public static final int CONTROLLER_1 = 0;
    public static final int CONTROLLER_2 = 1;
    public static final int CONTROLLER_3 = 2;
    public static final int CONTROLLER_4 = 3;
    public static final int MAX_CONTROLLERS = 4;
    public static final int BUTTON_STATE_HELD = 0;
    public static final int BUTTON_STATE_DOWN = 1;
    public static final int BUTTON_STATE_UP = 2;
    private static final int BUTTON_STATES_COUNT = 3;
    public static final int ANALOG_LEFT = 0;
    public static final int ANALOG_RIGHT = 1;
    public static final int ANALOG_L2 = 2;
    public static final int ANALOG_R2 = 3;
    private static final int ANALOG_CONTROL_COUNT = 4;
    public static final int ANALOG_AXIS_X = 0;
    public static final int ANALOG_AXIS_Y = 1;
    private static final int ANALOG_AXIS_COUNT = 2;
    public static boolean[][][] buttonState = null;
    public static float[][][] analogState = null;
    public static boolean[][] analogChanged = null;
    public static boolean[] controllerConnected = null;
    public static boolean serviceConnected = false;
    public static final int STATE_BUTTON = 0;
    public static final int STATE_ANALOG = 1;
    private static ArrayList<StateData> newStates = new ArrayList();

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        m_Activity = this;
        this.service = new MarmaladeService();
        buttonState = new boolean[3][4][25];
        analogState = new float[2][4][4];
        analogChanged = new boolean[4][4];
        controllerConnected = new boolean[4];
        this.service.BindService((Activity)this);
        this.service.addLeftRemap();
        this.service.hideSystemUI((Activity)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.service.UnbindService((Activity)this);
    }

    protected void onResume() {
        m_Activity = this;
        super.onResume();
        this.service.hideSystemUI((Activity)this);
    }

    protected void onPause() {
        m_Activity = null;
        super.onPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StartFrame() {
        if (buttonState != null && analogChanged != null) {
            for (int i = 0; i < 4; ++i) {
                int n;
                for (n = 0; n < 25; ++n) {
                    GTMarmaladeActivity.buttonState[1][i][n] = false;
                    GTMarmaladeActivity.buttonState[2][i][n] = false;
                }
                for (n = 0; n < 4; ++n) {
                    GTMarmaladeActivity.analogChanged[i][n] = false;
                }
            }
        }
        ArrayList<StateData> arrayList = newStates;
        synchronized (arrayList) {
            for (StateData stateData : newStates) {
                if (stateData.type == 0) {
                    GTMarmaladeActivity.buttonState[2][stateData.controllerId][stateData.controlKey] = !stateData.pressed;
                    GTMarmaladeActivity.buttonState[0][stateData.controllerId][stateData.controlKey] = stateData.pressed;
                    GTMarmaladeActivity.buttonState[1][stateData.controllerId][stateData.controlKey] = stateData.pressed;
                    continue;
                }
                if (stateData.type != 1) continue;
                GTMarmaladeActivity.analogState[0][stateData.controllerId][stateData.controlKey] = stateData.x;
                GTMarmaladeActivity.analogState[1][stateData.controllerId][stateData.controlKey] = stateData.y;
                GTMarmaladeActivity.analogChanged[stateData.controllerId][stateData.controlKey] = true;
            }
            newStates.clear();
        }
    }

    public static void AddLeftButtonRemap() {
        if (m_Activity != null && GTMarmaladeActivity.m_Activity.service != null) {
            GTMarmaladeActivity.m_Activity.service.addLeftRemap();
        }
    }

    public static void RemoveLeftButtonRemap() {
        if (m_Activity != null && GTMarmaladeActivity.m_Activity.service != null) {
            GTMarmaladeActivity.m_Activity.service.removeLeftRemap();
        }
    }

    public static void AddRightButtonRemap() {
        if (m_Activity != null && GTMarmaladeActivity.m_Activity.service != null) {
            GTMarmaladeActivity.m_Activity.service.addRightRemap();
        }
    }

    public static void RemoveRightButtonRemap() {
        if (m_Activity != null && GTMarmaladeActivity.m_Activity.service != null) {
            GTMarmaladeActivity.m_Activity.service.removeRightRemap();
        }
    }

    public static void HideAndroidSystemUI() {
        if (m_Activity != null && GTMarmaladeActivity.m_Activity.service != null) {
            GTMarmaladeActivity.m_Activity.service.hideSystemUI((Activity)m_Activity);
        }
    }

    public static void ClearControllerState(int n) {
        if (buttonState != null && analogChanged != null && n < 4) {
            int n2;
            for (n2 = 0; n2 < 25; ++n2) {
                GTMarmaladeActivity.buttonState[0][n][n2] = false;
                GTMarmaladeActivity.buttonState[1][n][n2] = false;
                GTMarmaladeActivity.buttonState[2][n][n2] = false;
            }
            for (n2 = 0; n2 < 4; ++n2) {
                GTMarmaladeActivity.analogChanged[n][n2] = false;
            }
        }
    }

    class MarmaladeService
    extends GreenThrottleService {
        MarmaladeService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ButtonAction(ControllerPlayer controllerPlayer, ControllerEvent.CommonCodes commonCodes, boolean bl) {
            int n = controllerPlayer.getPlayerNumber() - 1;
            if (n >= 4) {
                return;
            }
            int n2 = -1;
            switch (commonCodes) {
                case A_BUTTON: {
                    n2 = 0;
                    break;
                }
                case B_BUTTON: {
                    n2 = 1;
                    break;
                }
                case X_BUTTON: {
                    n2 = 3;
                    break;
                }
                case Y_BUTTON: {
                    n2 = 2;
                    break;
                }
                case L1_BUTTON: {
                    n2 = 8;
                    break;
                }
                case L2_BUTTON: {
                    n2 = 9;
                    break;
                }
                case L3_BUTTON: {
                    n2 = 10;
                    break;
                }
                case R1_BUTTON: {
                    n2 = 11;
                    break;
                }
                case R2_BUTTON: {
                    n2 = 12;
                    break;
                }
                case R3_BUTTON: {
                    n2 = 13;
                    break;
                }
                case BACK_BUTTON: {
                    n2 = 22;
                    break;
                }
                case START_BUTTON: {
                    n2 = 23;
                    break;
                }
                case HOME_BUTTON: {
                    n2 = 24;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_UP: {
                    n2 = 14;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_RIGHT: {
                    n2 = 17;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_DOWN: {
                    n2 = 15;
                    break;
                }
                case LEFT_ANALOG_AS_DPAD_LEFT: {
                    n2 = 16;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_UP: {
                    n2 = 18;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_RIGHT: {
                    n2 = 21;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_DOWN: {
                    n2 = 19;
                    break;
                }
                case RIGHT_ANALOG_AS_DPAD_LEFT: {
                    n2 = 20;
                    break;
                }
                case DPAD_LEFT: {
                    n2 = 6;
                    break;
                }
                case DPAD_RIGHT: {
                    n2 = 7;
                    break;
                }
                case DPAD_UP: {
                    n2 = 5;
                    break;
                }
                case DPAD_DOWN: {
                    n2 = 4;
                }
            }
            if (n2 != -1) {
                StateData stateData = new StateData();
                stateData.type = 0;
                stateData.controllerId = n;
                stateData.controlKey = n2;
                stateData.pressed = bl;
                ArrayList arrayList = newStates;
                synchronized (arrayList) {
                    newStates.add(stateData);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void AnalogEvent(ControllerPlayer controllerPlayer, ControllerEvent.CommonCodes commonCodes, float f, float f2) {
            int n = controllerPlayer.getPlayerNumber() - 1;
            if (n >= 4) {
                return;
            }
            int n2 = -1;
            switch (commonCodes) {
                case LEFT_ANALOG: {
                    n2 = 0;
                    break;
                }
                case RIGHT_ANALOG: {
                    n2 = 1;
                    break;
                }
                case L2_ANALOG: {
                    n2 = 2;
                    f2 = 0.0f;
                    break;
                }
                case R2_ANALOG: {
                    n2 = 3;
                    f2 = 0.0f;
                }
            }
            if (n2 != -1) {
                StateData stateData = new StateData();
                stateData.type = 1;
                stateData.controllerId = n;
                stateData.controlKey = n2;
                stateData.x = f;
                stateData.y = f2;
                ArrayList arrayList = newStates;
                synchronized (arrayList) {
                    newStates.add(stateData);
                }
            }
        }

        protected void ControllerAction(ControllerPlayer controllerPlayer, boolean bl) {
            int n = controllerPlayer.getPlayerNumber() - 1;
            if (n >= 4) {
                return;
            }
            GTMarmaladeActivity.controllerConnected[n] = bl;
        }

        protected void ServiceStatus(boolean bl) {
            if (bl) {
                Toast.makeText((Context)GTMarmaladeActivity.this, (CharSequence)"GCS connected", (int)0).show();
            } else {
                Toast.makeText((Context)GTMarmaladeActivity.this, (CharSequence)"GCS DIS-connected", (int)0).show();
            }
            serviceConnected = bl;
        }
    }

    class StateData {
        public int type;
        public int controllerId;
        public int controlKey;
        boolean pressed;
        float x;
        float y;

        StateData() {
        }
    }
}

