/* Copyright 2012 Green Throttle */

package com.greenthrottle.gcs.api;

import com.greenthrottle.gcs.api.ControllerInfo;
import com.greenthrottle.gcs.api.IGTControllerCallback;
 
interface IGTController {

	/*** PUBLIC API ***/
	
	/**
	 * Register callback to receive service events
	 */
    void registerCallback(IGTControllerCallback cb);
    
    /**
     * Remove a previously registered callback interface.
     */
    void unregisterCallback(IGTControllerCallback cb);
    
    /**
     * Start connecting to saved controllers.
     */
    void startAutoconnect();
    
    /**
     * Receive callbacks indicating controllers currently connected 
     */
    void queryCurrentBindings();
    
    /*** PRIVATE API ***/
    
    /**
     * Clear all saved controllers
     */
    void commandSavedControllersClear();
    void commandClearMRUControllersList(String tid);
    
    /**
     * Add saved controller
     */
     void commandSavedControllerAdd(String controller_bt_address);
  
  	/**
     * Remove saved controller. This method does NOT disconnect the saved controller
     * if it was connected.
     */
     void commandSavedControllerRemove(String controller_bt_address);
  
  	/**
  	 * Enumerate saved controllers
  	 */
  	void querySavedControllers();
  	ControllerInfo[] querySavedControllersSync();
    void queryMRUState();
    
  	/**
  	 * Enumerate saved controllers along with bound status.
  	 * Bound controllers will be returned with status as ControllerInfo.ControllerState.CONNECTED_BOUND.
  	 * Other controllers will be returned with status as ControllerInfo.ControllerState.DISCONNECTED.
  	 */
    ControllerInfo[] querySavedControllersWithBoundStatusSync();
    
    /**
     * Start or stop automatically connecting to saved controllers 
     */
    void commandEnableAutoconnect(boolean enable);
    void queryAutoconnectEnabled();
    
    /** the following commands require autoconnect to be disabled **/
    
    /**
     * Start BT discovery for new controllers
     */
    void queryScan();
    void queryRescanOnly();
   
    /**
     * Turn the DPAD synthesis functionality on or off
    */
    void commandControlDPADSynth(boolean on);
    
   	/**
   	 * Connect to a controller with given BT address
   	 */ 
    void commandConnectController(String tid, String controller_bt_address, boolean save);
    
    /** 
     * Disconnect from controller with given BT address
     */
    void commandDisconnectController(String tid, String controller_bt_address);
    
    /**
     * Disconnect from all controllers
     */
    void commandDisconnectAllControllers(String tid);
    
    /**
     * Enables or disables controllers based on the value passed. If controllers are disabled,
     * there will be NO outgoing connection to the controller. Scan, Auto connect and incoming
     * connections will all be disabled. Enabling the controllers will connect all paired
     * controllers and enable scan, auto connect and incoming connections.
     */
    void enableControllers (boolean enable);
    
    /**
     * Returns if controllers are enabled.
     */
    boolean controllersEnabled();
    
    /**
     * Removes the controller from the list of paired controllers, and disconnects
     * it if the controller is currently connected. 
     */
    void removePairedControllerAndDisconnect (String tid, String controller_bt_address);
}
