package com.greenthrottle.unitydroid;

import com.greenthrottle.gcs.api.ControllerEvent;
import com.greenthrottle.unifier.ControllerPlayer;
import com.greenthrottle.unifier.GreenThrottleService;

import java.lang.reflect.Field;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import android.hardware.SensorManager;
import android.hardware.SensorEventListener;

import com.unity3d.player.UnityPlayerActivity;

public class UnityInputUnifierActivity extends UnityPlayerActivity {
	
	private static String GAME_OBJECT_NAME = "GreenThrottleSingleton"; 
	
	private static UnityInputUnifierActivity currentActivity = null;
	
	private boolean shouldKillAccelerometer = false;
	private boolean inCutscene = false;
	
	private UnityService service = null;

	protected void onCreate(Bundle savedInstanceState) 
	{ 
		// call UnityPlayerActivity.onCreate()
		super.onCreate(savedInstanceState);
		
		currentActivity = this;
		service = new UnityService();
		
		service.BindService(this);
		service.addLeftRemap();
		service.hideSystemUI(this);
		
		if(shouldKillAccelerometer)
		{
			killAccelerometer();
		}
	}

	protected void onDestroy()
	{
		super.onDestroy();
		service.UnbindService(this);
	}
	
	protected void onResume()
	{
		currentActivity = this;
		super.onResume();
		service.hideSystemUI(this);
		if(shouldKillAccelerometer)
		{
			killAccelerometer();
		}
	}
	
	protected void onPause()
	{
		currentActivity = null;
		super.onPause();
	}

	//_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-

	public static void addLeftButtonRemap()
	{
		if( currentActivity != null  && currentActivity.service != null )
		{
			currentActivity.service.addLeftRemap();
		}
	}

	public static void removeLeftButtonRemap()
	{
		if( currentActivity != null && currentActivity.service != null )
		{
			currentActivity.service.removeLeftRemap();
		}
	}

	public static void addRightButtonRemap()
	{
		if( currentActivity != null && currentActivity.service != null )
		{
			currentActivity.service.addRightRemap();
		}
	}

	public static void removeRightButtonRemap()
	{
		if( currentActivity != null && currentActivity.service != null )
		{
			currentActivity.service.removeRightRemap();
		}
	}
	
	public static void hideAndroidSystemUI()
	{
		if( currentActivity != null  && currentActivity.service != null )
		{
			currentActivity.service.hideSystemUI(currentActivity);
		}
	
	}
	
	public static void disableAccelerometer()
	{
		if( currentActivity != null )
		{
			currentActivity.shouldKillAccelerometer = true;
			currentActivity.killAccelerometer();
		}
	}
	
	public static void enableAccelerometer()
	{
		if( currentActivity != null )
		{
			currentActivity.shouldKillAccelerometer = false;
		}
	}
	
	public static void enableCutsceneMode()
	{
		if( currentActivity != null )
		{
			currentActivity.inCutscene = true;
		}
	}
	
	public static void disableCutsceneMode()
	{
		if( currentActivity != null )
		{
			currentActivity.inCutscene = false;
		}
	}
	//_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-
	
	//functions callbacks in unity
	private static final String ButtonPress = "set_Button";
	private static final String ButtonRelease = "clear_Button";
	private static final String analogEvent = "analog_Event";
	private static final String controllerEvent = "controller_Event";
	private static final String serviceEvent = "service_Event";

	//string definitions of various buttons
	private static final String DIRECTION_UP = "U";
	private static final String DIRECTION_RIGHT = "R";
	private static final String DIRECTION_DOWN = "D";
	private static final String DIRECTION_LEFT = "L";

	private static final String DIRECTION_LEFT_ANALOG_UP = "LAU";
	private static final String DIRECTION_LEFT_ANALOG_RIGHT = "LAR";
	private static final String DIRECTION_LEFT_ANALOG_DOWN = "LAD";
	private static final String DIRECTION_LEFT_ANALOG_LEFT = "LAL";

	private static final String DIRECTION_RIGHT_ANALOG_UP = "RAU";
	private static final String DIRECTION_RIGHT_ANALOG_RIGHT = "RAR";
	private static final String DIRECTION_RIGHT_ANALOG_DOWN = "RAD";
	private static final String DIRECTION_RIGHT_ANALOG_LEFT = "RAL";
	
	private static final String BUTTON_A = "A";
	private static final String BUTTON_B = "B";
	private static final String BUTTON_X = "X";
	private static final String BUTTON_Y = "Y";
	
	private static final String BUTTON_BACK = "SEL";
	private static final String BUTTON_START = "ST";
	private static final String BUTTON_GREENTHROTTLE = "GT";
	
	private static final String BUTTON_L1 = "L1";
	private static final String BUTTON_L2 = "L2";
	private static final String BUTTON_L3 = "L3";
	private static final String BUTTON_R1 = "R1";
	private static final String BUTTON_R2 = "R2";
	private static final String BUTTON_R3 = "R3";
	
	//analog controls
	private static final String LEFT_ANALOG = "LA";
	private static final String RIGHT_ANALOG = "RA";
	private static final String L2_ANALOG = "L2A";
	private static final String R2_ANALOG = "R2A";
		
	//controller connect and disconnect prefixes
	private static final String CONTROLLER_CONNECTED = "XC";
	private static final String CONTROLLER_DISCONNECTED = "XD";	
	
	private void controllerAnalogEvent(ControllerPlayer player, ControllerEvent.CommonCodes code, float x, float y) 
	{
		if(inCutscene)
		{
			return;
		}
	
		String codeString = "";
		boolean hasY = false;
		switch (code) 
		{
		case LEFT_ANALOG:
			codeString = UnityInputUnifierActivity.LEFT_ANALOG;
			hasY = true;
			break;
		case RIGHT_ANALOG:
			codeString = UnityInputUnifierActivity.RIGHT_ANALOG;
			hasY = true;
			break;
		case L2_ANALOG:
			codeString = UnityInputUnifierActivity.L2_ANALOG;
			break;
		case R2_ANALOG:
			codeString = UnityInputUnifierActivity.R2_ANALOG;
			break;
		}
		
		AnalogEvent(player, codeString, x, y, hasY);
	}

	private void controllerButtonEvent(ControllerPlayer player, ControllerEvent.CommonCodes code, boolean isPressed)
	{
		if( inCutscene )
		{
			//send a touch event to cancel the cutscene from the start, back, or B buttons
			if( !isPressed && 
					( code.equals(ControllerEvent.CommonCodes.START_BUTTON) || code.equals(ControllerEvent.CommonCodes.BACK_BUTTON)
					|| code.equals(ControllerEvent.CommonCodes.B_BUTTON) || code.equals(ControllerEvent.CommonCodes.HOME_BUTTON) )
				)
			{
				this.runOnUiThread( new Runnable()
				{
					public void run()
					{
						currentActivity.dispatchTouchEvent(
								android.view.MotionEvent.obtain(
										android.os.SystemClock.uptimeMillis()-2, 
										android.os.SystemClock.uptimeMillis()-2, 
										android.view.MotionEvent.ACTION_DOWN, 0, 0, 0
								)
						);
						currentActivity.dispatchTouchEvent(
								android.view.MotionEvent.obtain(
										android.os.SystemClock.uptimeMillis()-1, 
										android.os.SystemClock.uptimeMillis()-1, 
										android.view.MotionEvent.ACTION_UP, 0, 0, 0
								)
						);
					}
				});
			}
			// While in a cutscene the UnityPlayer pauses and queues messages from these events to handle them all
			// when resumed.  Rather than having Unity try to respond to all of these messages simultaneously on 
			// resume, clear the controller in-game and wait on more messages until the cutscene ends.  Let the
			// home button through, but cancel the rest.
			if( !code.equals(ControllerEvent.CommonCodes.HOME_BUTTON) )
			{
				return;
			}
		}		
		
		String button = null;
		
		switch(code)
		{
		case A_BUTTON:
			button = BUTTON_A;
			break;
		case B_BUTTON:
			button = BUTTON_B;
			break;
		case X_BUTTON:
			button = BUTTON_X;
			break;
		case Y_BUTTON:
			button = BUTTON_Y;
			break;
		case L1_BUTTON:
			button = BUTTON_L1;
			break;
		case L2_BUTTON:
			button = BUTTON_L2;
			break;
		case L3_BUTTON:
			button = BUTTON_L3;
			break;
		case R1_BUTTON:
			button = BUTTON_R1;
			break;
		case R2_BUTTON:
			button = BUTTON_R2;
			break;
		case R3_BUTTON:
			button = BUTTON_R3;
			break;
		case BACK_BUTTON:
			button = BUTTON_BACK;
			break;
		case START_BUTTON:
			button = BUTTON_START;
			break;
		case HOME_BUTTON:
			button = BUTTON_GREENTHROTTLE;
			break;
		case LEFT_ANALOG_AS_DPAD_UP:
			button = DIRECTION_LEFT_ANALOG_UP;
			break;
		case LEFT_ANALOG_AS_DPAD_RIGHT:
			button = DIRECTION_LEFT_ANALOG_RIGHT;
			break;
		case LEFT_ANALOG_AS_DPAD_DOWN:
			button = DIRECTION_LEFT_ANALOG_DOWN;
			break;
		case LEFT_ANALOG_AS_DPAD_LEFT:
			button = DIRECTION_LEFT_ANALOG_LEFT;
			break;
			
		case RIGHT_ANALOG_AS_DPAD_UP:
			button = DIRECTION_RIGHT_ANALOG_UP;
			break;
		case RIGHT_ANALOG_AS_DPAD_RIGHT:
			button = DIRECTION_RIGHT_ANALOG_RIGHT;
			break;
		case RIGHT_ANALOG_AS_DPAD_DOWN:
			button = DIRECTION_RIGHT_ANALOG_DOWN;
			break;
		case RIGHT_ANALOG_AS_DPAD_LEFT:
			button = DIRECTION_RIGHT_ANALOG_LEFT;
			break;
		case DPAD_LEFT:
			button = DIRECTION_LEFT;
			break;
		case DPAD_RIGHT:
			button = DIRECTION_RIGHT;
			break;
		case DPAD_UP:
			button = DIRECTION_UP;
			break;
		case DPAD_DOWN:
			button = DIRECTION_DOWN;
			break;
		}

		if (button != null)
		{
			ButtonAction(player, button, isPressed);
		}
	}

	private void ButtonAction(ControllerPlayer player, String code, boolean press)
	{
		com.unity3d.player.UnityPlayer.UnitySendMessage(GAME_OBJECT_NAME,(press ? ButtonPress : ButtonRelease),Integer.toString(player.getPlayerNumber()) + code);		
	}
	
	private void AnalogEvent(ControllerPlayer player, String code, float x, float y, boolean hasY) {
		String params[] = { Integer.toString(player.getPlayerNumber()), code, Float.toString(x), 
				(hasY ? Float.toString(y) : "")  };
		com.unity3d.player.UnityPlayer.UnitySendMessage(GAME_OBJECT_NAME,analogEvent, android.text.TextUtils.join(",", params));
	}
	
	private void ControllerAction(ControllerPlayer player, String code) {
		com.unity3d.player.UnityPlayer.UnitySendMessage(GAME_OBJECT_NAME,controllerEvent,Integer.toString(player.getPlayerNumber()) + code);
	}
	
	private void ServiceStatus(boolean isConnected)
	{
		com.unity3d.player.UnityPlayer.UnitySendMessage(GAME_OBJECT_NAME,serviceEvent,Boolean.toString(isConnected));		
	}

	private void killAccelerometer()
	{
		SensorManager sm = (SensorManager)getSystemService(Context.SENSOR_SERVICE);
		if(sm != null)
		{
			//Log.i("UnityInputUnifierActivity", "Found Sensor Manager");
			try
			{
				com.unity3d.player.UnityPlayer up = null;
				Field fields[] = UnityPlayerActivity.class.getDeclaredFields();
				int i;
				for(i = 0; i < fields.length; ++i)
				{
					if(fields[i].getType() == com.unity3d.player.UnityPlayer.class)
					{
						fields[i].setAccessible(true);
						up = (com.unity3d.player.UnityPlayer)fields[i].get(this);
						//fields[i].setAccessible(false);
						break;
					}
				}
				
				if(up != null)
				{
					//Log.i("UnityInputUnifierActivity", "Found Unity Player");
					SensorEventListener sel = null;
					fields = com.unity3d.player.UnityPlayer.class.getDeclaredFields();
					for(i = 0; i < fields.length; ++i)
					{
						//find SensorEventListener interface
						//Log.i("UnityInputUnifierActivity", "field " + fields[i].getName() + " class: " + fields[i].getType().getName());
						if(fields[i].getType().getName().equals("com.unity3d.player.p"))
						{
							fields[i].setAccessible(true);
							sel = (SensorEventListener)fields[i].get(up);
							break;
						}
					}
					
					if(sel != null)
					{
						//Log.i("UnityInputUnifierActivity", "Unregistering sensor listener");
						sm.unregisterListener(sel);
					}
				}
				
			}
			catch(Exception e)
			{
				Log.w("UnityInputUnifierActivity", "Exception during attempt to find sensor listener " + e.toString());
			}
		}
	}
	
	class UnityService extends GreenThrottleService
	{
		protected void ButtonAction(ControllerPlayer player, ControllerEvent.CommonCodes code, boolean pressed)
		{
			controllerButtonEvent(player, code, pressed);
		}

		protected void AnalogEvent(ControllerPlayer player, ControllerEvent.CommonCodes code, float x, float y)
		{
			controllerAnalogEvent(player, code, x, y);
		}

		protected void ControllerAction(ControllerPlayer player, boolean connected)
		{
			UnityInputUnifierActivity.this.ControllerAction(player, connected?CONTROLLER_CONNECTED:CONTROLLER_DISCONNECTED);
		}

		protected void ServiceStatus(boolean isConnected)
		{
			
			UnityInputUnifierActivity.this.ServiceStatus(isConnected);
			if(isConnected)
			{
				// As part of the sample, tell the user what happened.
				Toast.makeText(UnityInputUnifierActivity.this, "GCS connected",
						Toast.LENGTH_SHORT).show();			// As part of the sample, tell the user what happened.
			}
			else
			{
				Toast.makeText(UnityInputUnifierActivity.this, "GCS DIS-connected",
						Toast.LENGTH_SHORT).show();
			}
		}
	}
} // %%%%%% END CLASS %%%%%%%%