package com.greenthrottle.gcs.api;

import android.os.Parcel;
import android.os.Parcelable;

public class ServiceStatusEvent implements Parcelable {

	public enum StatusCode
	{
		INVALID ("(invalid)"),
		NEW_CONTROLLER_FOUND ("New controller found"),
		CONTROLLER_CONNECTED ("Controller connected"),
		CONTROLLER_DISCONNECTED ("Controller disconnected"),
		CONTROLLER_DISCOVERYSCAN_STARTED ("Started scan discovery of new controllers"),
		CONTROLLER_DISCOVERYSCAN_FINISHED ("Finished scan discovery of new controllers"),
		QUERY_NUM_CONTROLLERS_VALUE ("Query(Num controllers) result"),
		QUERY_BOUND_CONTROLLERS_VALUE ("Query(Bound controller) result"),
		CONTROLLER_UNBOUND ("Controller unbound from a common name"),
		CONTROLLER_CONNECT_ATTEMPT ("Attempting connect to controller"),
		CONTROLLER_CONNECT_FAILED ("Could not connect to controller"),
		
		// debugging status
		MRU_EMPTY ("MRU is empty"),
		MRU_NOT_EMPTY ("MRU not empty"),
		
		AUTOCONNECT_BEGIN ("Starting autoconnect"),
		AUTOCONNECT_END ("Ending autoconnect"),
		AUTOCONNECT_SKIP ("Skipped autoconnect-connected"),
		
		AUTOCONNECT_ENABLED ("Autoconnect enabled"),
		AUTOCONNECT_DISABLED ("Autoconnect disabled"),
		
		CONTROLLER_VERSION ("Controller version");
		/// ----- ///
		
		String name;
		
		StatusCode(String displayName)
		{
			name = displayName;
		}
				
		public String n()
		{ return name; }
	}
	
	public StatusCode code()
	{
		return m_code;
	}
	public String encodedData()
	{
		return m_encodedData;
	}
	
	public int describeContents() {
		// TODO Auto-generated method stub
		return 0;
	}

	public void writeToParcel(Parcel out, int arg1) {
		// TODO Auto-generated method stub
		out.writeValue(m_code);
		if (m_encodedData == null)
			out.writeString("");
		else
			out.writeString(m_encodedData);
	}

	public static final Parcelable.Creator<ServiceStatusEvent> CREATOR
	= new Parcelable.Creator<ServiceStatusEvent>() {
		public ServiceStatusEvent createFromParcel(Parcel in) {
			return new ServiceStatusEvent(in);
		}

		public ServiceStatusEvent[] newArray(int size) {
			return new ServiceStatusEvent[size];
		}
	};

	private ServiceStatusEvent()
	{	
	}
	
	private ServiceStatusEvent(Parcel in) {
		m_code = (StatusCode) in.readValue(StatusCode.class.getClassLoader());
		m_encodedData = in.readString();
	}
	
	public ServiceStatusEvent setCode(StatusCode c)
	{
		m_code = c;
		return this;
	}
	public ServiceStatusEvent setEncodedData(String s)
	{
		m_encodedData = s;
		return this;
	}
	
	public static ServiceStatusEvent make_controller_discovered(String bt_address,String controller_type)
	{
		return (
				(new ServiceStatusEvent()
				.setCode(StatusCode.NEW_CONTROLLER_FOUND)
				.setEncodedData(bt_address+"="+controller_type))
				);
	}
	public static ServiceStatusEvent make_controller_connected(String bt_address)
	{
		return (
		(new ServiceStatusEvent()
		.setCode(StatusCode.CONTROLLER_CONNECTED)
		.setEncodedData(bt_address))
		);
	}
	public static ServiceStatusEvent make_controller_version(String bt_address, String version)
	{
		return (
		(new ServiceStatusEvent()
		.setCode(StatusCode.CONTROLLER_VERSION)
		.setEncodedData(bt_address+"="+version))
		);
	}
	public static ServiceStatusEvent make_controller_connect_attempt(String bt_address)
	{
		return (
		(new ServiceStatusEvent()
		.setCode(StatusCode.CONTROLLER_CONNECT_ATTEMPT)
		.setEncodedData(bt_address))
		);
	}
	public static ServiceStatusEvent make_controller_connect_failed(String bt_address)
	{
		return (
		(new ServiceStatusEvent()
		.setCode(StatusCode.CONTROLLER_CONNECT_FAILED)
		.setEncodedData(bt_address))
		);
	}
	public static ServiceStatusEvent make_controller_disconnected(String bt_address)
	{
		return (
				(new ServiceStatusEvent()
				.setCode(StatusCode.CONTROLLER_DISCONNECTED)
				.setEncodedData(bt_address))
				);
	}
	public static ServiceStatusEvent make_discoveryscan_started()
	{
		return (
				(new ServiceStatusEvent()
				.setCode(StatusCode.CONTROLLER_DISCOVERYSCAN_STARTED))
				);
	}
	public static ServiceStatusEvent make_discoveryscan_ended()
	{
		return (
				(new ServiceStatusEvent()
				.setCode(StatusCode.CONTROLLER_DISCOVERYSCAN_FINISHED))
				);
	}
	public static ServiceStatusEvent make_query_result_num_controllers_connected(int value)
	{
		return (
				(new ServiceStatusEvent()
				.setCode(StatusCode.QUERY_NUM_CONTROLLERS_VALUE)
				.setEncodedData(""+value))
				);
	}
	public static ServiceStatusEvent make_query_result_binding_pair(String bt_address,String binding_name)
	{
		return (
				(new ServiceStatusEvent()
				.setCode(StatusCode.QUERY_BOUND_CONTROLLERS_VALUE)
				.setEncodedData(bt_address+"="+binding_name))
				);
	}
	public static ServiceStatusEvent make_query_result_broken_binding_pair(String bt_address,String binding_name)
	{
		return (
				(new ServiceStatusEvent()
		.setCode(StatusCode.CONTROLLER_UNBOUND)
		.setEncodedData(bt_address+"!"+binding_name))
		);
	}
	
	public static ServiceStatusEvent make_debug_event(StatusCode c) {
		return (
				(new ServiceStatusEvent()
				.setCode(c))
				);
	}
	
	//------------------------------------------------- vars
	
	StatusCode m_code = null;
	String m_encodedData = null;
	
}
