package com.greenthrottle.javainputtest;

import com.greenthrottle.gcs.api.ControllerEvent;
import com.greenthrottle.gcs.api.ControllerInfo;
import com.greenthrottle.gcs.api.IGTController;
import com.greenthrottle.gcs.api.IGTControllerCallback;
import com.greenthrottle.gcs.api.ServiceStatusEvent;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.Process;
import android.widget.Toast;
import android.util.Log;

import java.util.HashMap;
import java.util.Map;

@SuppressLint("NewApi")
public class InputManager
{
	private boolean mIsBound = false;
	private boolean mServiceIsConnected = false;

	private IGTController mService = null;

	private InputHandler mHandler = null;

//	private int mRescan = 0;

	private boolean mScanTaskRunning;
	private ScanForControllersTask mScanTask;
	
	private JavaInputTestActivity mMainApp;

	public static Map<String,ControllerPlayer> m_boundPlayerControllers = new HashMap<String,ControllerPlayer>();
	public class ControllerPlayer 
	{
		public ControllerPlayer(int player_num)
		{
			m_playerNumber = player_num;
		}
		
		public int getPlayerNumber()
		{
			return m_playerNumber;
		}

		public String getPlayer()
		{
			return "player_" + m_playerNumber;
		}
		
		public void setPlayerId(int player_num)
		{
			m_playerNumber = player_num;
		}
		
		public String getControllerBtAddress() 
		{
			return m_myControllerBtAddress;
		}

		public void setControllerBtAddress(String controller_bt_address) 
		{
			m_myControllerBtAddress = controller_bt_address;
		}

		String m_myControllerBtAddress;
		int m_playerNumber;
		
		public ControllerPlayer bindControllerToMe(String controller_bt_address) 
		{
			// TODO Auto-generated method stub
			setControllerBtAddress(controller_bt_address);
			return this;
		}

	}
		
	public InputManager(JavaInputTestActivity mainActivity)
	{
		mHandler = new InputHandler();
//		mRescan = 0;
		mMainApp = mainActivity;
    }

	public void onPause()
	{
//		mRescan = 0;
	}

	public boolean isServiceConnected()
	{
		return mServiceIsConnected;
	}

	public boolean isBound()
	{
		return mIsBound;
	}
	
	public void bindService()
	{
		if(!mIsBound)
		{
			mIsBound = mMainApp.bindService(new Intent(IGTController.class.getName()), mHandler, Context.BIND_AUTO_CREATE);
		}
	}

	public void unbindService()
	{
		if(mIsBound)
		{
			try
			{
				mService.unregisterCallback(mHandler);
			}
			catch(RemoteException e)
			{
				e.printStackTrace();
			}

			try
			{
				mMainApp.unbindService(mHandler);
			}
			catch(Exception e)
			{
				//don't care
			}
			mIsBound = false;
		}
	}


	private String getTid()
	{
			return String.format("tid_%d", Process.myPid());
	}

	private void discoverControllers()
	{
		if(mIsBound && mService != null)
		{
			searchForControllers();
		}
	}
	
	private class ScanForControllersTask extends Thread {
		public void run() {
			while (mScanTaskRunning) {
				Log.i("InputManagerScanTask", "Resuming scan");
				discoverControllers();
				
				boolean interruptedDuringSleep = false;
				try {
					Thread.sleep(20 * 1000);
				} catch (InterruptedException e) {
					interruptedDuringSleep = true; // This means that resumeScanTask was called while sleeping, so don't wait below
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				synchronized(this) {
					//if (m_boundPlayerControllers.size() > 0) {
					if (!interruptedDuringSleep) {
						Log.i("InputManagerScanTask", "Pausing scan");
						try {
							wait();
						} catch (InterruptedException e) {
							// TODO Auto-generated catch block
							Log.i("InputManagerScanTask", "Awake");
						}
					}
				}
				
			}
		}
	}

	private void startScanTask() {
		if (mScanTask == null) {
			mScanTaskRunning = true;
			mScanTask = new ScanForControllersTask();
			mScanTask.start();
		}
		else
		{
			resumeScanTask();
		}
	}
	
	private void resumeScanTask() {
		synchronized (mScanTask) {
			mScanTask.interrupt();
		}
	}
	
	private void searchForControllers()
	{
		try
		{
			Log.i("InputManager", "Attempting to scan.");

			mService.queryScan();
		}
		catch(RemoteException e)
		{
			e.printStackTrace();
		}
	}


	private void queryCurrentNamedControllerBindings()
	{
		try
		{
			mService.queryCurrentBindings();
		}
		catch(RemoteException e)
		{
			e.printStackTrace();
		}
	}
	
	@SuppressLint("NewApi")
	public class InputHandler extends IGTControllerCallback.Stub implements ServiceConnection
	{
		Handler mCallbackHandler = new Handler();
	
		public void onServiceConnected(ComponentName className, IBinder service)
		{

			mService = IGTController.Stub.asInterface(service);

			try
			{
				mService.registerCallback(this);
			}
			catch(RemoteException e)
			{
				e.printStackTrace();
			}
			mServiceIsConnected = true;
			mMainApp.setServiceConnected(mServiceIsConnected);
			try {
				mService.startAutoconnect();
			} catch (RemoteException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			queryCurrentNamedControllerBindings();

			// As part of the sample, tell the user what happened.
			Toast.makeText(mMainApp, "GCS connected",
					Toast.LENGTH_SHORT).show();
	
		}

		public void onServiceDisconnected(ComponentName className)
		{
			mService = null;
			mServiceIsConnected = false;
			mMainApp.setServiceConnected(mServiceIsConnected);

			// As part of the sample, tell the user what happened.
			Toast.makeText(mMainApp, "GCS disconnected",
					Toast.LENGTH_SHORT).show();			
		}


		public class ControllerEventHandler implements Runnable
		{
			ControllerEvent mEvent = null;
			public ControllerEventHandler(ControllerEvent e)
			{
				mEvent = e;
			}

			public void run()
			{
				//Toast.makeText(GlobalInfo.mainApp, "GCS controllerEvent", Toast.LENGTH_SHORT).show();			

				if(m_boundPlayerControllers.containsKey(mEvent.id()))
				{
					mMainApp.handleControllerEvent(mEvent);
				}
				else
				{
					Log.e("InputHandler", "Cannot handle events for controller '" + mEvent.id() + "' because it was not detected");
				}
			}
		}
		
		public void controllerEvent(ControllerEvent e) throws RemoteException
		{
			mCallbackHandler.post(new ControllerEventHandler(e));
		}

		public void valueChanged(int value) throws RemoteException
		{
			/*
			mCallbackHandler.post(new Runnable()
					{
						@Override
						public void run()
						{
							Toast.makeText(GlobalInfo.mainApp, "GCS valueChanged", Toast.LENGTH_SHORT).show();			
						}
					});
			*/
		}

		public class StatusUpdateEventHandler implements Runnable
		{
			String mControllerId = null;
			String mPlayer = null;
			int mPlayerId = 1;
			ServiceStatusEvent.StatusCode mStatus = ServiceStatusEvent.StatusCode.INVALID;

			public StatusUpdateEventHandler(String controllerId, ServiceStatusEvent.StatusCode status)
			{
				mControllerId = controllerId;
				mStatus = status;
			}

			ControllerPlayer getController()
			{
				ControllerPlayer controller = null;
				if(m_boundPlayerControllers.containsKey(mControllerId))
				{
					controller = m_boundPlayerControllers.get(mControllerId);
				}
				else
				{
					controller = new ControllerPlayer(mPlayerId);
					controller.setControllerBtAddress(mControllerId);
					m_boundPlayerControllers.put(mControllerId, controller);
				}

				return controller;
			}

			void splitControllerAndPlayer()
			{
				if(mControllerId.contains("="))
				{
					String[] list = mControllerId.split("=");
					mControllerId = list[0];
					mPlayer = list[1];
					list = mPlayer.split("_");
					mPlayerId = Integer.parseInt(list[1]);
				}
			}

			public void run()
			{
				 //Toast.makeText(GlobalInfo.mainApp, "GCS serviceStatusUpdateEvent: " + mData, Toast.LENGTH_SHORT).show();			

				switch(mStatus)
				{
					case NEW_CONTROLLER_FOUND:
					case CONTROLLER_CONNECTED:
						{
							/*
							splitControllerAndPlayer();
							ControllerPlayer controller = getController();
							Log.i("InputManager", "Controller event: " + controller.getControllerBtAddress() + ": " + mStatus.name() );
							mStatus = ServiceStatusEvent.StatusCode.CONTROLLER_CONNECTED;
							if(controller.getPlayer().equals(mPlayer) == false)
							{
								Log.i("InputManager", "Switching player id from " + controller.getPlayer() + " to " + mPlayer);
								controller.setPlayerId(mPlayerId);
							}
							mMainApp.setControllerConnected(true);
							*/
							Log.i("InputManager", "Controller event: " + mControllerId + ": CONTROLLER_CONNECTED " );
							
						}
						break;
					case CONTROLLER_DISCONNECTED:
						{	
							ControllerPlayer controller = getController();
							m_boundPlayerControllers.remove(mControllerId);
							Log.i("InputManager", "Controller event: " + controller.getControllerBtAddress() + ": " + mStatus.name() );
							if (m_boundPlayerControllers.size() == 0) {
								mMainApp.setControllerConnected(false);
								startScanTask();
							}
						}
						break;
					case CONTROLLER_DISCOVERYSCAN_STARTED:
						Log.i("InputManager", "Discovery started.");

						break;
					case CONTROLLER_DISCOVERYSCAN_FINISHED:
						Log.i("InputManager", "Discovery finished.");
						//connectControllers();
						break;
					case QUERY_BOUND_CONTROLLERS_VALUE:
						{
							splitControllerAndPlayer();
							Log.i("InputManager", "Received QUERY_BOUND_CONTROLLERS_VALUE with data: " + mControllerId + " player: " + mPlayer);
							ControllerPlayer controller = getController();
							if(controller.getPlayer().equals(mPlayer) == false)
							{
								Log.i("InputManager", "Switching player id from " + controller.getPlayer() + " to " + mPlayer);
								controller.setPlayerId(mPlayerId);
							}
							mMainApp.setControllerConnected(true);
						}
						break;
					default:
						break;
				}

			}
		}

		public void serviceStatusUpdateEvent(ServiceStatusEvent e) throws RemoteException
		{
			if( e != null)
			{
				mCallbackHandler.post(new StatusUpdateEventHandler(e.encodedData(), e.code()));
			}
		}

		public void commandAck(String arg0, String arg1) throws RemoteException 
		{
			// TODO Auto-generated method stub
			
		}

		public void controllerInfo(ControllerInfo[] arg0) throws RemoteException 
		{
			// TODO Auto-generated method stub

			if(arg0 != null)
			{
				mCallbackHandler.post(new ControllerInfoHandler(arg0));
			}
		}
		
		public class ControllerInfoHandler implements Runnable
		{
			ControllerInfo[] ia;
			
			public ControllerInfoHandler(ControllerInfo[] arg0)
			{
				ia = arg0;
			}
			
			public void run()
			{
				if (ia.length == 0)
				{
					Log.w("InputManager","ControllerInfo array length is 0, doing queryscan instead");
					startScanTask();
				}
			}
		}
	}
}
