package com.greenthrottle.javainputtest;

import android.app.Activity;
import android.os.Bundle;
import android.os.Message;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.greenthrottle.gcs.api.ControllerEvent;
import com.greenthrottle.unifier.ControllerPlayer;
import com.greenthrottle.unifier.GreenThrottleService;

//import android.util.Log;
public class JavaInputTestActivity extends Activity 
{
	private LinearLayout controllerList = null;
	
	private View[] controllerViews = new View[4];
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_java_input_test);
        
        controllerList = (LinearLayout)findViewById(R.id.controller_list);
        for(int i = 0; i < controllerViews.length; ++i)
        {
        	controllerViews[i] = null;
        }
        
        gts = new JavaTestGTS();
        gts.BindService(this);
    }
    
    @Override
    public void onDestroy()
    {
    	gts.UnbindService(this);
    	super.onDestroy();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) 
    {
        getMenuInflater().inflate(R.menu.activity_java_input_test, menu);
        return true;
    }
    
    private void handleAnalogEvent(View controller, ControllerEvent.CommonCodes code, float x, float y)
    {
    	TextView tv = null;
    	boolean useBoth = false;
    	switch(code)
    	{
    	case LEFT_ANALOG:
    		tv = (TextView)controller.findViewById(R.id.tv_left_analog);
    		useBoth = true;
    		break;
    	case RIGHT_ANALOG:
    		tv = (TextView)controller.findViewById(R.id.tv_right_analog);
    		useBoth = true;
    		break;
    	case L2_ANALOG:
    		tv = (TextView)controller.findViewById(R.id.tv_l2_analog);
    		break;
    	case R2_ANALOG:
    		tv = (TextView)controller.findViewById(R.id.tv_r2_analog);
    		break;
    	}
    	
    	if(tv != null)
    	{
    		if(useBoth)
    		{
        		tv.setText("( " + x + "," + y + " )");
    		}
    		else
    		{
        		tv.setText("( " + x + " )");
    		}
    	}
    }
    
    private void handleControllerEvent(View controller, ControllerEvent.CommonCodes code, boolean isDown)
    {
    	CheckBox cb = null;
    	
    	//Log.i("JavaInputTest", "Got controller event " + event.toString());
    	switch(code)
    	{
    	case A_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_a);
        	break;
    	case B_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_b);
        	break;
    	case X_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_x);
        	break;
    	case Y_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_y);
        	break;
    	case START_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_start);
        	break;
    	case BACK_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_back);
        	break;
    	case HOME_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_home);
        	break;
    	case R1_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_r1);
        	break;
    	case R2_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_r2);
        	break;
    	case R3_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_r3);
        	break;
    		
    	case L1_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_l1);
        	break;
    	case L2_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_l2);
        	break;
    	case L3_BUTTON:
        	cb =(CheckBox)controller.findViewById(R.id.cb_l3);
        	break;
    	case DPAD_UP:
    	case DPAD_RIGHT:
    	case DPAD_DOWN:
    	case DPAD_LEFT:
        	cb =(CheckBox)controller.findViewById(R.id.cb_dpad);
        	break;
    		
    	case LEFT_ANALOG_AS_DPAD_UP:
    	case LEFT_ANALOG_AS_DPAD_RIGHT:
    	case LEFT_ANALOG_AS_DPAD_DOWN:
    	case LEFT_ANALOG_AS_DPAD_LEFT:
        	cb =(CheckBox)controller.findViewById(R.id.cb_leftanalog);
        	break;
    		
    	case RIGHT_ANALOG_AS_DPAD_UP:
    	case RIGHT_ANALOG_AS_DPAD_RIGHT:
    	case RIGHT_ANALOG_AS_DPAD_DOWN:
    	case RIGHT_ANALOG_AS_DPAD_LEFT:
        	cb =(CheckBox)controller.findViewById(R.id.cb_rightanalog);
        	break;
    	}
    	
    	if(cb != null)
    	{
    		cb.setChecked(isDown);
    	}
    }
    
    public void setServiceConnected(boolean serviceConnected)
    {
    	CheckBox cb = (CheckBox)findViewById(R.id.cb_service_connect);
    	cb.setChecked(serviceConnected);
    }
    
    public View newControllerView(int playerId)
    {
		LayoutInflater inflator = LayoutInflater.from(this);
		View view = inflator.inflate(R.layout.controller_info, null);
		
		TextView tv = (TextView)view.findViewById(R.id.tv_controller_name);
		tv.setText("controller " + playerId);
		
		return view;
    }
    
    private JavaTestGTS gts = null;
    
    

    
    class JavaTestGTS extends GreenThrottleService 
    {
        class GTSHandler extends Handler
        {
        	public static final int HANDLER_BUTTON = 0;
        	public static final int HANDLER_ANALOG = 1;
        	public static final int HANDLER_CONTROLLER = 2;
        	public static final int HANDLER_SERVICE = 3;
        	
    		@Override
    		public void handleMessage(Message msg) 
    		{
    			switch(msg.what)
    			{
    			case HANDLER_BUTTON:
    				doButtonAction((GButton)msg.obj);
    				break;
    			case HANDLER_ANALOG:
    				doAnalogEvent((GAnalog)msg.obj);
    				break;
    			case HANDLER_CONTROLLER:
    				doControllerAction((GController)msg.obj);
    				break;
    			case HANDLER_SERVICE:
    				doServiceStatus((Boolean)msg.obj);
    				break;
    			}
    		}    	
        }

        private GTSHandler m_handler = null;
        
        public JavaTestGTS()
        {
        	super();
        	m_handler = new GTSHandler();
        }
    	
        class GButton
        {
        	public ControllerPlayer player;
        	public ControllerEvent.CommonCodes code;
        	public boolean pressed;
        	
        }
        
    	protected void ButtonAction(ControllerPlayer player, ControllerEvent.CommonCodes code, boolean pressed)
    	{
    		Message msg = m_handler.obtainMessage(GTSHandler.HANDLER_BUTTON);
    		GButton b = new GButton();
    		b.player = player;
    		b.code = code;
    		b.pressed = pressed;
    		msg.obj = b;
    		m_handler.sendMessage(msg);
    	}
    	
    	protected void doButtonAction(GButton b) //ControllerPlayer player, ControllerEvent.CommonCodes code, boolean pressed)
    	{
    		int playerId = b.player.getPlayerNumber();
    		if(playerId < controllerViews.length)
    		{
        		handleControllerEvent(controllerViews[playerId - 1], b.code, b.pressed);
    		}
    	}

    	class GAnalog
    	{
        	public ControllerPlayer player;
        	public ControllerEvent.CommonCodes code;
        	public float x;
        	public float y;
    	}
    	
    	protected void AnalogEvent(ControllerPlayer player, ControllerEvent.CommonCodes code, float x, float y)
    	{
    		Message msg = m_handler.obtainMessage(GTSHandler.HANDLER_ANALOG);
    		GAnalog b = new GAnalog();
    		b.player = player;
    		b.code = code;
    		b.x = x;
    		b.y = y;
    		msg.obj = b;
    		m_handler.sendMessage(msg);
    	}
    	
    	protected void doAnalogEvent(GAnalog b) //ControllerPlayer player, ControllerEvent.CommonCodes code, float x, float y)
    	{
    		int playerId = b.player.getPlayerNumber();
    		if(playerId < controllerViews.length)
    		{
        		handleAnalogEvent(controllerViews[playerId - 1], b.code, b.x, b.y);
    		}    	
    	}
    	
    	class GController
    	{
    		public ControllerPlayer player;
    		public boolean connected;
    	}
    	
    	protected void ControllerAction(ControllerPlayer player, boolean connected)
    	{
    		Message msg = m_handler.obtainMessage(GTSHandler.HANDLER_CONTROLLER);
    		GController b = new GController();
    		b.player = player;
    		b.connected = connected;
    		msg.obj = b;
    		m_handler.sendMessage(msg);    		
    	}
    	
    	protected void doControllerAction(GController b) //ControllerPlayer player, boolean connected)
    	{
        	CheckBox cb = null;
        	int playerId = b.player.getPlayerNumber();
    		switch(playerId)
    		{
    		case 1:
	        	cb = (CheckBox)findViewById(R.id.cb_c1);
	        	break;
    		case 2:
	        	cb = (CheckBox)findViewById(R.id.cb_c2);
	        	break;
    		case 3:
	        	cb = (CheckBox)findViewById(R.id.cb_c3);
	        	break;
    		case 4:
	        	cb = (CheckBox)findViewById(R.id.cb_c4);
	        	break;
    		}
    		
    		if(cb != null)
    		{
	        	cb.setChecked(b.connected);
	        	if(b.connected)
	        	{
	        		if(controllerViews[playerId - 1] == null)
	        		{
	        			controllerViews[playerId - 1] = newControllerView(playerId);
	        			controllerList.addView(controllerViews[playerId - 1]);
	        		}
	        	}
	        	else
	        	{
	        		if(controllerViews[playerId - 1] != null)
	        		{
	        			controllerList.removeView(controllerViews[playerId - 1]);
	        			controllerViews[playerId - 1] = null;
	        		}
	        	}	        	
	        	
    		}
    	}
    	
    	protected void ServiceStatus(boolean isConnected)
    	{
    		m_handler.sendMessage(m_handler.obtainMessage(GTSHandler.HANDLER_SERVICE, (Boolean)isConnected));   
    	}
    	
    	protected void doServiceStatus(boolean isConnected)
    	{
    		setServiceConnected(isConnected);
    	}
    };
    
}
