#pragma strict

var hFrames : int = 4;
var vFrames : int = 4;

private var hSize : float;
private var vSize : float;

private var animList : AnimationLabel[];
private var frame : int;
private var startFrame : int;
private var endFrame : int;
private var frameTime : float;
private var curTime : float;
private var loop : boolean;

private var mat : Material;

function Start()
{
	hSize = 1f / hFrames;
	vSize = 1f / vFrames;
	
	mat = renderer.material;
	mat.SetTextureScale("_MainTex", Vector2(hSize, vSize));

	var list : Array = this.gameObject.GetComponents(AnimationLabel);
	var i : int;

	animList = new AnimationLabel[list.length];
	for( i = 0 ; i < list.length ; ++i )
	{
		animList[i] = list[i];
	}
	
	StartAnimation("default");
}

function Update()
{
	curTime += Time.deltaTime;
	
	if( curTime >= frameTime )
	{
		curTime -= frameTime;

		++frame;
		if( frame == endFrame )
		{
			if( loop )
			{
				frame = startFrame;
			}
			else
			{
				StartAnimation("default");
			}
		}
		
		mat.SetTextureOffset( "_MainTex", Vector2( hSize * (frame % hFrames), 1f - (vSize * (1 + (frame / vFrames))) ) );
	}
}

function StartAnimation( name : String )
{
	var i : int = 0;
	while( animList[i].animName != name )
	{
		++i;
	}
	
	frame = animList[i].startFrame;
	startFrame = animList[i].startFrame;
	endFrame = startFrame + animList[i].frameCount;
	frameTime = animList[i].time;
	loop = animList[i].loop;
	curTime = 0f;
	
	mat.SetTextureOffset( "_MainTex", Vector2( hSize * (frame % hFrames), 1f - (vSize * (1 + (frame / vFrames))) ) );
}

function StartAnimation( name : String, totalTime : float )
{
	StartAnimation(name);
	frameTime = totalTime / (endFrame - startFrame);
}

function SetPause( pause : boolean )
{
	//pausing should skip the update, so just use enabled instead
	enabled = !pause;
}