#pragma strict

var hasHit : boolean = false;
private var velocity : Vector3;
private var player : Vector3;

var collisionMessage : String = "BulletCollided";

function Awake()
{
	player = Vector3.zero;
}

function Update()
{
	transform.localPosition += velocity * Time.deltaTime;
	
	if( transform.localPosition.x < -Globals.levelxBounds || 
		transform.localPosition.x > Globals.levelxBounds || 
		transform.localPosition.z < -Globals.levelzBounds || 
		transform.localPosition.z > Globals.levelzBounds )
	{
		Destroy( this.gameObject );
	}
}

function SetVelocity( vel : Vector3 )
{
	velocity = vel;
}

function SetPlayer( pl : int )
{
	player.y = pl;
}

function OnTriggerEnter( object : Collider )
{
	if( !hasHit )
	{
		hasHit = true;
		object.gameObject.SendMessage(collisionMessage,velocity + player);
		Destroy( this.gameObject );
	}
}