#pragma strict

static var axisRotations : Quaternion[];

static var levelxBounds : float = 15f;
static var levelzBounds : float = 10f;

static var recipSqrt2 : float = 1f / Mathf.Sqrt(2f);

enum DIRECTIONS {
					RIGHT = 0,
					DOWN_RIGHT = 1,
					DOWN = 2,
					DOWN_LEFT = 3,
					LEFT = 4,
					UP_LEFT = 5,
					UP = 6,
					UP_RIGHT = 7
				}

static function GetDirection( x : int, z : int ) : Quaternion
{
	if( z == 1 )
	{
		if( x == 1 )
		{
			return axisRotations[DIRECTIONS.DOWN_LEFT];
		}
		else if( x == 0 )
		{
			return axisRotations[DIRECTIONS.DOWN];
		}
		else if( x == -1 )
		{
			return axisRotations[DIRECTIONS.DOWN_RIGHT];
		}
	}
	else if( z == 0 )
	{
		if( x == 1 )
		{
			return axisRotations[DIRECTIONS.LEFT];
		}
		else if( x == -1 )
		{
			return axisRotations[DIRECTIONS.RIGHT];
		}
	}
	else if( z == -1 )
	{
		if( x == 1 )
		{
			return axisRotations[DIRECTIONS.UP_LEFT];
		}
		else if( x == 0 )
		{
			return axisRotations[DIRECTIONS.UP];
		}
		else if( x == -1 )
		{
			return axisRotations[DIRECTIONS.UP_RIGHT];
		}
	}
	return Quaternion.identity;
}

function Awake()
{
	//just need to initialize global data, no need for updates after that
	enabled = false;
	
	axisRotations = new Quaternion[8];
	var i : int;
	for( i = 0 ; i < axisRotations.Length ; ++i )
	{
		switch( i )
		{
			case 0: axisRotations[i] = Quaternion.Euler(0,  0,0);	break;
			case 1: axisRotations[i] = Quaternion.Euler(0, 45,0);	break;
			case 2: axisRotations[i] = Quaternion.Euler(0, 90,0);	break;
			case 3: axisRotations[i] = Quaternion.Euler(0,135,0);	break;
			case 4: axisRotations[i] = Quaternion.Euler(0,180,0);	break;
			case 5: axisRotations[i] = Quaternion.Euler(0,225,0);	break;
			case 6: axisRotations[i] = Quaternion.Euler(0,270,0);	break;
			case 7: axisRotations[i] = Quaternion.Euler(0,315,0);	break;
		}
	}
}

