#pragma strict

private var inputManager : InputManager;
var paused : boolean;

var p1Disconnected : GUIText;
var p2Disconnected : GUIText;

var pauseText : GUIText;

private var player1Controller : boolean = true;
private var player2Controller : boolean = true;

private var numPlayers : int = 1;

function Start()
{
	paused = false;
	pauseText.enabled = false;
	p1Disconnected.enabled = false;
	p2Disconnected.enabled = false;
	
	inputManager = InputManager.Instance;
	
	player1Controller = !GreenThrottle.Instance.isServiceActive || GreenThrottle.Instance.connectedState[0];
	player2Controller =  !GreenThrottle.Instance.isServiceActive || GreenThrottle.Instance.connectedState[1];
	
	GreenThrottle.ControllerConnectedStateChange += this.HandleControllerEvent;
}

function OnDestroy()
{
	GreenThrottle.ControllerConnectedStateChange -= this.HandleControllerEvent;
}

function Update()
{
	if( inputManager.GetKeyDown(InputManager.IB_START) || Input.GetKeyDown(KeyCode.Minus) || Input.GetKeyDown(KeyCode.Menu))
	{
		Pause(player1Controller && ((numPlayers < 2) ? true : (player2Controller)));
	}
}

#if UNITY_ANDROID
function OnApplicationPause()
{
	Pause(false);
}
#endif

function UpdateControllerMessages( hasP1 : boolean, playAnimP1 : boolean, hasP2 : boolean, playAnimP2 : boolean )
{
	if( !hasP1 || !hasP2 )
	{
		if( !hasP1 )
		{
			inputManager.ClearController( 1 );
		}
		if( !hasP2 )
		{
			inputManager.ClearController( 2 );
		}
		
		Pause(false);
	}

	if( paused )
	{
		if(playAnimP1)
		{
			p1Disconnected.enabled = true;	
		}
		
		if(playAnimP2)
		{
			p2Disconnected.enabled = true;	
		}
		
	}
}

function HandleControllerEvent( player : int, isConnected : boolean )
{
	var prevP1 : boolean = player1Controller;
	var prevP2 : boolean = player2Controller;
	
	if( player == 1 )
	{
		player1Controller = isConnected;
	}
	
	if( player == 2 )
	{
		player2Controller = isConnected;
		if(isConnected)
		{
			numPlayers = 2;
		}
	}
		
	//pause if we are missing an active player
	UpdateControllerMessages( player1Controller, prevP1 != player1Controller, 
										(numPlayers < 2) ? true : (player2Controller),
										(numPlayers < 2) ? false : (prevP2 != player2Controller)
										);
}

private function Pause( allowUnpause : boolean )
{
	if( !paused )
	{
		paused = true;
		pauseText.enabled = true;		
		Time.timeScale = 0f;
	}
	else if( allowUnpause )
	{
		paused = false;
		pauseText.enabled = false;		
		p1Disconnected.enabled = false;
		p2Disconnected.enabled = false;
		
		Time.timeScale = 1f;
	}
}

function TogglePause( obj : GameObject )
{
	Pause(player1Controller && ((numPlayers < 2) ? true : (player2Controller)));
}
