#pragma strict

var baseSpeed : float = 6f;
private var lineSpeed : float;
private var diagSpeed : float;

var bullet : GameObject;
var fireRate : float = .2f;
private var lastShot : float;
var bulletBaseSpeed : float = 10f;
private var bulletLineSpeed : float;
private var bulletDiagSpeed : float;

var isPlayer1 : boolean = true;
var inputManager : InputManager;

private var animController : AnimationControl;

function Awake()
{
	lineSpeed = baseSpeed;
	diagSpeed = baseSpeed * Globals.recipSqrt2;
	bulletLineSpeed = bulletBaseSpeed;
	bulletDiagSpeed = bulletBaseSpeed * Globals.recipSqrt2;
	lastShot = fireRate;
	animController = this.gameObject.GetComponent(AnimationControl);
	inputManager = InputManager.Instance;
}

function Update ()
{
	var xvel : float = 0f;
	var zvel : float = 0f;
	var mult : float;
	
	//first find player movement
	if( isPlayer1 )
	{
		#if UNITY_ANDROID
			xvel += inputManager.GetAxis(InputManager.IA_X_ANALOG, 1);
			zvel += inputManager.GetAxis(InputManager.IA_Y_ANALOG, 1);
		#endif
		
		#if UNITY_EDITOR || !UNITY_ANDROID
			xvel += ( (Input.GetAxis("P1X") < -.5f) ? -1f : 0f);
			xvel += ( (Input.GetAxis("P1X") > .5f) ? 1f : 0f);
			zvel += ( (Input.GetAxis("P1Y") < -.5f) ? -1f : 0f);
			zvel += ( (Input.GetAxis("P1Y") > .5f) ? 1f : 0f);
		#endif
	}
	else
	{
		#if UNITY_ANDROID
			xvel += inputManager.GetAxis(InputManager.IA_X_ANALOG, 2);
			zvel += inputManager.GetAxis(InputManager.IA_Y_ANALOG, 2);
		#endif

		#if UNITY_EDITOR || !UNITY_ANDROID
			xvel += ( (Input.GetAxis("P2X") < -.5f) ? -1f : 0f);
			xvel += ( (Input.GetAxis("P2X") > .5f) ? 1f : 0f);
			zvel += ( (Input.GetAxis("P2Y") < -.5f) ? -1f : 0f);
			zvel += ( (Input.GetAxis("P2Y") > .5f) ? 1f : 0f);
		#endif
	}
	
	//adjust speed based on whether player is moving diagonally
	if( xvel == 0 || zvel == 0 )
	{
		transform.localPosition += Vector3(xvel, 0f, zvel) * lineSpeed * Time.deltaTime;
	}
	else
	{
		mult = (xvel * xvel) + (zvel * zvel);
		if( mult > 1f )
		{
			mult = 1f / Mathf.Sqrt(mult);
			xvel *= mult;
			zvel *= mult;
		}
		transform.localPosition += Vector3(xvel, 0f, zvel) * diagSpeed * Time.deltaTime;
	}
	
	//keep player inside level boundaries
	if( transform.localPosition.x < -Globals.levelxBounds )
	{
		transform.localPosition.x = -Globals.levelxBounds;
	}
	else if( transform.localPosition.x > Globals.levelxBounds )
	{
		transform.localPosition.x = Globals.levelxBounds;
	}
	
	if( transform.localPosition.z < -Globals.levelzBounds )
	{
		transform.localPosition.z = -Globals.levelzBounds;
	}
	else if( transform.localPosition.z > Globals.levelzBounds )
	{
		transform.localPosition.z = Globals.levelzBounds;
	}

	//get input for player shooting
	xvel = 0;
	zvel = 0;
	
	if( isPlayer1 )
	{
		#if UNITY_ANDROID
			xvel += inputManager.GetAxis(InputManager.IA_FIREX, 1);
			zvel += inputManager.GetAxis(InputManager.IA_FIREY, 1);
		#endif

		#if UNITY_EDITOR || !UNITY_ANDROID
			xvel += ( (Input.GetAxis("P1FireX") < -.5f) ? -1f : 0f);
			xvel += ( (Input.GetAxis("P1FireX") > .5f) ? 1f : 0f);
			zvel += ( (Input.GetAxis("P1FireY") < -.5f) ? -1f : 0f);
			zvel += ( (Input.GetAxis("P1FireY") > .5f) ? 1f : 0f);
		#endif
	}
	else
	{
		#if UNITY_ANDROID
			xvel += inputManager.GetAxis(InputManager.IA_FIREX, 2);
			zvel += inputManager.GetAxis(InputManager.IA_FIREY, 2);
		#endif

		#if UNITY_EDITOR || !UNITY_ANDROID
			xvel += ( (Input.GetAxis("P2FireX") < -.5f) ? -1f : 0f);
			xvel += ( (Input.GetAxis("P2FireX") > .5f) ? 1f : 0f);
			zvel += ( (Input.GetAxis("P2FireY") < -.5f) ? -1f : 0f);
			zvel += ( (Input.GetAxis("P2FireY") > .5f) ? 1f : 0f);
		#endif
	}
	
	lastShot += Time.deltaTime;
	
	//only continue if the player is shooting
	if( xvel != 0 || zvel != 0 )
	{
		transform.localRotation = Globals.GetDirection(xvel, zvel);
		
		if( lastShot >= fireRate )
		{
			var obj : GameObject = Instantiate( bullet, transform.localPosition, transform.localRotation );
			if( xvel == 0 || zvel == 0 )
			{
				obj.GetComponent(BulletMovement).SetVelocity( bulletLineSpeed * Vector3(xvel, 0f, zvel) );
				obj.GetComponent(BulletMovement).SetPlayer( isPlayer1 ? 1 : 2 );
			}
			else
			{
				obj.GetComponent(BulletMovement).SetVelocity( bulletDiagSpeed * Vector3(xvel, 0f, zvel) );
				obj.GetComponent(BulletMovement).SetPlayer( isPlayer1 ? 1 : 2 );
			}
			obj.transform.localPosition.y = bullet.transform.localPosition.y;
			obj.active = true;
			lastShot = 0f;
		}
	}
}
