/* Copyright 2012 Green Throttle */

package com.greenthrottle.gcs.api;

import com.greenthrottle.gcs.api.ControllerInfo;
import com.greenthrottle.gcs.api.IGTControllerCallback;
 
interface IGTController {

	/*** PUBLIC API ***/
	
	/**
	 * Register callback to receive service events
	 */
    void registerCallback(IGTControllerCallback cb);
    
    /**
     * Remove a previously registered callback interface.
     */
    void unregisterCallback(IGTControllerCallback cb);
    
    /**
     * Start connecting to saved controllers.
     */
    void startAutoconnect();
    
    /**
     * Receive callbacks indicating controllers currently connected 
     */
    void queryCurrentBindings();
    
    /*** PRIVATE API ***/
    
    /**
     * Clear all saved controllers
     */
    void commandSavedControllersClear();
    void commandClearMRUControllersList(String tid);
    
    /**
     * Add saved controller
     */
     void commandSavedControllerAdd(String controller_bt_address);
  
  	/**
     * Remove saved controller
     */
     void commandSavedControllerRemove(String controller_bt_address);
  
  	/**
  	 * Enumerate saved controllers
  	 */
  	void querySavedControllers();
  	ControllerInfo[] querySavedControllersSync();
    void queryMRUState();
    
    /**
     * Start or stop automatically connecting to saved controllers 
     */
    void commandEnableAutoconnect(boolean enable);
    void queryAutoconnectEnabled();
    
    /** the following commands require autoconnect to be disabled **/
    
    /**
     * Start BT discovery for new controllers
     */
    void queryScan();
    void queryRescanOnly();
   
   	/**
   	 * Connect to a controller with given BT address
   	 */ 
    void commandConnectController(String tid, String controller_bt_address, boolean save);
    
    /** 
     * Disconnect from controller with given BT address
     */
    void commandDisconnectController(String tid, String controller_bt_address);
    
    /**
     * Disconnect from all controllers
     */
    void commandDisconnectAllControllers(String tid);
}
