package com.greenthrottle.unitydroid;

import com.greenthrottle.gcs.api.ControllerEvent;
import com.greenthrottle.gcs.api.ControllerInfo;
import com.greenthrottle.gcs.api.IGTController;
import com.greenthrottle.gcs.api.IGTControllerCallback;
import com.greenthrottle.gcs.api.ServiceStatusEvent;
import com.greenthrottle.gcs.api.ControllerEvent.AnalogDataType;
import com.greenthrottle.unitydroid.ControllerPlayer;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.lang.reflect.Field;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.widget.Toast;
import android.view.View;
import android.hardware.SensorManager;
import android.hardware.SensorEventListener;

import com.unity3d.player.UnityPlayerActivity;

public class UnityInputUnifierActivity extends UnityPlayerActivity {
	
	private static String GAME_OBJECT_NAME = "GreenThrottleSingleton"; 
	
	private static UnityInputUnifierActivity currentActivity = null;
	
	private boolean shouldKillAccelerometer = false;
	
	protected void onCreate(Bundle savedInstanceState) { 
		// call UnityPlayerActivity.onCreate()
		super.onCreate(savedInstanceState);
		simpleCodeRemap = 
				new HashMap<ControllerEvent.CommonCodes,ControllerEvent.CommonCodes>();
		addLeftRemap();
		doBindService();
		hideSystemUI();
		
		if(shouldKillAccelerometer)
		{
			killAccelerometer();
		}
	}

	protected void onResume()
	{
		currentActivity = this;
		super.onResume();
		hideSystemUI();
		if(shouldKillAccelerometer)
		{
			killAccelerometer();
		}
	}
	
	protected void onPause()
	{
		currentActivity = null;
		super.onPause();
	}

	///////////////////////////////////////////////////////

	boolean mIsBound = false;
	boolean m_serviceIsConnected = false;
	/** The primary interface we will be calling on the service. */
	IGTController mService = null;


	void doBindService() {

		if (!mIsBound)
		{
			mIsBound = bindService(new Intent(IGTController.class.getName()),
					mConnection, Context.BIND_AUTO_CREATE);
		}
	}

	void doUnbindService() {
		if (mIsBound) {
			// If we have received the service, and hence registered with
			// it, then now is the time to unregister.
			if (mService != null) {
				try {
					mService.unregisterCallback(mCallback);
				} catch (RemoteException e) {
					// There is nothing special we need to do if the service
					// has crashed.
				}
			}

			// Detach our existing connection.
			unbindService(mConnection);
			mIsBound = false;
		}
	}
	
	void doStartAutoconnect() {
		if (mIsBound) {
			if (mService != null) {
				try {
					mService.startAutoconnect();
				} catch (RemoteException e) {
					// There is nothing special we need to do if the service
					// has crashed.
				}
			}
		}
	}
	
	void queryCurrentNamedControllerBindings()
	{
		if (mIsBound) {
			if (mService != null) {
				try {
					//make up a random number for the TID
					mService.queryCurrentBindings();
				} catch (RemoteException e) {
					// There is nothing special we need to do if the service
					// has crashed.
				}
			}
		}
	}
	
	private void controllerConnected(String controller_bt_address)
	{
		String player = null;
		int playerNumberAssigned = -1; 
		if(controller_bt_address.contains("="))
		{
			// controller is bound
			String[] list = controller_bt_address.split("=");
			controller_bt_address = list[0];
			player = list[1];

			list = player.split("_");
			playerNumberAssigned = Integer.parseInt(list[1]);
			ControllerPlayer ctrlp = new ControllerPlayer(playerNumberAssigned);
			ControllerAction(ctrlp, CONTROLLER_CONNECTED);
			m_boundPlayerControllers.put(controller_bt_address,ctrlp.bindControllerToMe(controller_bt_address));
		}
		else
		{
			// controller is not bound
		}
	}
	
	private void controllerDisconnected(String controller_bt_address)
	{
		//remove from unbound, and remove from player entry
		//TODO: handle disconnect better in case it reconnects shortly after
		ControllerPlayer ctrlp = m_boundPlayerControllers.remove(controller_bt_address);
		if (ctrlp != null)
		{
			ControllerAction(ctrlp, CONTROLLER_DISCONNECTED);
		}
	}
	
	public void handleServiceStatusEvent(ServiceStatusEvent e)
	{
		if (e == null)
		{ return; }
		switch (e.code())
		{
		case CONTROLLER_CONNECTED:
			controllerConnected(e.encodedData());
			break;
		case CONTROLLER_DISCONNECTED:
			controllerDisconnected(e.encodedData());
			break;
		case QUERY_BOUND_CONTROLLERS_VALUE:
			//EXAMPLE-CODE: just print it ...but useful code will want to process the mapping and utilize it somehow
			Log.i("UnityInputUnifierActivity","mapping received: "+( e.encodedData() == null ? "(null)" : e.encodedData()));
			controllerConnected(e.encodedData());
			break;
		default:
			//Log.w("UnityInputUnifierActivity","unhandled code: ["+e.toString()+"]");
			break;
		}
	}

	public void handleControllerInfoMessage(ControllerInfo[] ia)
	{

		
		Log.i("UnityInputUnifierActivity","message received from service...controller info data follows:");
		if (ia == null)
		{
			Log.w("UnityInputUnifierActivity","ControllerInfo array is null!");
			return;
		}
		if (ia.length == 0)
		{
			Log.w("UnityInputUnifierActivity","ControllerInfo array length is 0");
			return;
		}
		for (ControllerInfo ctrlInfo : ia)
		{
			Log.i("UnityInputUnifierActivity","controller bt address = "+ctrlInfo.btAddress()
												+ " controller name = "+(ctrlInfo.name() == null ? "(null)" : ctrlInfo.name())
												+ " controller cname = "+(ctrlInfo.sysCName() == null ? "(null)" : ctrlInfo.sysCName())
												+ " status = "+ctrlInfo.state().toString()
					);
		}
		Log.i("UnityInputUnifierActivity","(no more controller info objects in message)");
	}
	
	private ServiceConnection mConnection = new ServiceConnection() {
		public void onServiceConnected(ComponentName className,
				IBinder service) {
			// This is called when the connection with the service has been
			// established, giving us the service object we can use to
			// interact with the service.  We are communicating with our
			// service through an IDL interface, so get a client-side
			// representation of that from the raw service object.
			mService = IGTController.Stub.asInterface(service);

			// We want to monitor the service for as long as we are
			// connected to it.
			try {
				mService.registerCallback(mCallback);
			} catch (RemoteException e) {
				// In this case the service has crashed before we could even
				// do anything with it; we can count on soon being
				// disconnected (and then reconnected if it can be restarted)
				// so there is no need to do anything here.
				e.printStackTrace();
			}
			m_serviceIsConnected = true;
			
			doStartAutoconnect();
			queryCurrentNamedControllerBindings();
			
			// As part of the sample, tell the user what happened.
			Toast.makeText(UnityInputUnifierActivity.this, "GCS connected",
					Toast.LENGTH_SHORT).show();
		}

		public void onServiceDisconnected(ComponentName className) {
			// This is called when the connection with the service has been
			// unexpectedly disconnected -- that is, its process crashed.
			mService = null;

			// As part of the sample, tell the user what happened.
			Toast.makeText(UnityInputUnifierActivity.this, "GCS DIS-connected",
					Toast.LENGTH_SHORT).show();
		}
	};

	private IGTControllerCallback mCallback = new IGTControllerCallback.Stub() {
		/**
		 * This is called by the remote service regularly to tell us about
		 * new values.  Note that IPC calls are dispatched through a thread
		 * pool running in each process, so the code executing here will
		 * NOT be running in our main thread like most other things -- so,
		 * to update the UI, we need to use a Handler to hop over there.
		 */

		public void controllerEvent(ControllerEvent e) throws RemoteException 
		{
			//be very very careful! You're huntin' multithreaded wabbit....
			//...like the events below, the safe way would be to post to a message queue and thus funnel
			// through 1 thread. However, with careful synchronization in the call target, latency can be
			// reduced by calling directly
			UnityInputUnifierActivity.this.handleControllerEvent(e);
		}

		public void serviceStatusUpdateEvent(ServiceStatusEvent e) throws RemoteException 
		{
			m_GCSMessageHandler.sendMessage(m_GCSMessageHandler.obtainMessage(HANDLER_MSG__SERVICE_STATUS_UPDATE_EVENT,e));
		}

		/**
		 * response:   "OK"  ,   "REJECTED"
		 * extended_response (if not null or ""):  the TID this client specified when it made the request
		 */
		@Override
		public void commandAck(String response,String extended_response) throws RemoteException 
		{
			if (response == null)
			{ return; } //guard
			//Log.i("UnityInputUnifierActivity", "response = "+response+(extended_response == null ? "" : (" , extended response = "+extended_response)));
		}

		@Override
		public void controllerInfo(ControllerInfo[] ia)
				throws RemoteException {
			m_GCSMessageHandler.sendMessage(m_GCSMessageHandler.obtainMessage(HANDLER_MSG__CONTROLLER_INFO,ia));
		}
	};

	private static final int HANDLER_MSG__SERVICE_STATUS_UPDATE_EVENT = 1;
	private static final int HANDLER_MSG__CONTROLLER_INFO = 2;
	
	private Handler m_GCSMessageHandler = new Handler()
	{
		@Override
		public void handleMessage(Message msg) {
			switch (msg.what) {
			case HANDLER_MSG__SERVICE_STATUS_UPDATE_EVENT:
				handleServiceStatusEvent((ServiceStatusEvent)msg.obj);
				break;
			case HANDLER_MSG__CONTROLLER_INFO:
				handleControllerInfoMessage((ControllerInfo[])msg.obj);
				break;
			default:
				super.handleMessage(msg);
			}
		}
	};

	public static Map<String,ControllerPlayer> m_boundPlayerControllers = new HashMap<String,ControllerPlayer>();
	public static Vector<Integer> m_playerNumberAssignments = new Vector<Integer>();
	
	//_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-

	public static void addLeftButtonRemap()
	{
		if( currentActivity != null )
		{
			currentActivity.addLeftRemap();
		}
	}

	public static void removeLeftButtonRemap()
	{
		if( currentActivity != null )
		{
			currentActivity.removeLeftRemap();
		}
	}

	public static void addRightButtonRemap()
	{
		if( currentActivity != null )
		{
			currentActivity.addRightRemap();
		}
	}

	public static void removeRightButtonRemap()
	{
		if( currentActivity != null )
		{
			currentActivity.removeRightRemap();
		}
	}
	
	public static void hideAndroidSystemUI()
	{
		if( currentActivity != null )
		{
			currentActivity.hideSystemUI();
		}
	
	}
	
	public static void disableAccelerometer()
	{
		if( currentActivity != null )
		{
			currentActivity.shouldKillAccelerometer = true;
			currentActivity.killAccelerometer();
		}
	}
	
	public static void enableAccelerometer()
	{
		if( currentActivity != null )
		{
			currentActivity.shouldKillAccelerometer = false;
		}
	}
	//_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-

	private void addLeftRemap()
	{
		if( !simpleCodeRemap.containsKey(ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_DOWN))
		{
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_DOWN,
					ControllerEvent.CommonCodes.DPAD_DOWN);
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_LEFT,
					ControllerEvent.CommonCodes.DPAD_LEFT);
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_UP,
					ControllerEvent.CommonCodes.DPAD_UP);
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_RIGHT,
					ControllerEvent.CommonCodes.DPAD_RIGHT);
		}
	}
	
	private void removeLeftRemap()
	{
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_DOWN);
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_LEFT);
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_UP);
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.LEFT_ANALOG_AS_DPAD_RIGHT);
	}
	
	private void addRightRemap()
	{
		if( !simpleCodeRemap.containsKey(ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_DOWN))
		{
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_DOWN,
					ControllerEvent.CommonCodes.A_BUTTON);
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_LEFT,
					ControllerEvent.CommonCodes.X_BUTTON);
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_UP,
					ControllerEvent.CommonCodes.Y_BUTTON);
			simpleCodeRemap.put(
					ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_RIGHT,
					ControllerEvent.CommonCodes.B_BUTTON);
		}
	}
	
	private void removeRightRemap()
	{
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_DOWN);
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_LEFT);
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_UP);
		simpleCodeRemap.remove(ControllerEvent.CommonCodes.RIGHT_ANALOG_AS_DPAD_RIGHT);
	}
	
	public void handleControllerEvent(ControllerEvent e)
	{
		if (e == null)
		{ return; } //it's public so gonna take some caution...

		e = remap(e);
		int code = e.cCode().v();
		if ((code >= ControllerEvent.CommonCodes.__DPAD_BEGIN__.v())
				&& (code <= ControllerEvent.CommonCodes.__DPAD_END__.v())
				)
		{
			//dpad event
			controllerDPADEvent(e);
		}
		else if ((code >= ControllerEvent.CommonCodes.__BUTTONS_BEGIN__.v())
				&& (code <= ControllerEvent.CommonCodes.__BUTTONS_END__.v())
				)
		{
			//button event
			controllerButtonEvent(e);
		}
		else if (code >= ControllerEvent.CommonCodes.__ANALOG_DPAD_BEGIN__.v() 
				&&  code <= ControllerEvent.CommonCodes.__ANALOG_DPAD_END__.v())
		{
			controllerAnalogDPADEvent(e);
		}
		else if (code >= ControllerEvent.CommonCodes.__ANALOG_BEGIN__.v() 
				&&  code <= ControllerEvent.CommonCodes.__ANALOG_END__.v())
		{
			controllerAnalogEvent(e);
		} 
	}

	private ControllerEvent remap(ControllerEvent e)
	{
		if (e.cCode() == null)
		{ return e; }
		
		ControllerEvent.CommonCodes em = this.simpleCodeRemap.get(e.cCode());
		if (em != null)
		{
			e.changeCommonCode(em);
		}
		return e;
	}
	
	private void controllerDPADEvent(ControllerEvent e)
	{
		//find the player that the event is meant for
		ControllerPlayer player = m_boundPlayerControllers.get(e.id());

		//Log.i("UnityInputUnifierActivity", "UIL: Getting player input for player " + (player == null ? "0" : player.getPlayerNumber()));

		if (player == null)
		{ Log.i("UnityInputUnifierActivity", "no player for this event"); return; } //no player corresponds to this controller

		if (e.action().equals(ControllerEvent.Action.ACTION_DOWN) || e.action().equals(ControllerEvent.Action.ACTION_UP))
		{
			if (e.cCode().equals(ControllerEvent.CommonCodes.DPAD_LEFT))
			{
				ButtonAction(player, DIRECTION_LEFT, e.action().equals(ControllerEvent.Action.ACTION_DOWN));
			}
			else if (e.cCode().equals(ControllerEvent.CommonCodes.DPAD_RIGHT))
			{
				ButtonAction(player, DIRECTION_RIGHT, e.action().equals(ControllerEvent.Action.ACTION_DOWN));
			}
			else if (e.cCode().equals(ControllerEvent.CommonCodes.DPAD_UP))
			{
				ButtonAction(player, DIRECTION_UP, e.action().equals(ControllerEvent.Action.ACTION_DOWN));
			}
			else if (e.cCode().equals(ControllerEvent.CommonCodes.DPAD_DOWN))
			{
				ButtonAction(player, DIRECTION_DOWN, e.action().equals(ControllerEvent.Action.ACTION_DOWN));
			}
		}
	}
	
	private void controllerAnalogEvent(ControllerEvent e) {
		//find the player that the event is meant for
		ControllerPlayer player = m_boundPlayerControllers.get(e.id());
		if (player == null)
		{ Log.i("UnityInputUnifierActivity", "no player for this event"); return; } //no player corresponds to this controller
		
		String code = "";
		switch (e.cCode()) {
		case LEFT_ANALOG:
			code = UnityInputUnifierActivity.LEFT_ANALOG;
			break;
		case RIGHT_ANALOG:
			code = UnityInputUnifierActivity.RIGHT_ANALOG;
			break;
		case L2_ANALOG:
			code = UnityInputUnifierActivity.L2_ANALOG;
			break;
		case R2_ANALOG:
			code = UnityInputUnifierActivity.R2_ANALOG;
			break;
		}
		
		AnalogEvent(player, code, e);
	}

	private void controllerAnalogDPADEvent(ControllerEvent e)
	{
		//find the player that the event is meant for
		ControllerPlayer player = m_boundPlayerControllers.get(e.id());
		
		//Log.i("UnityInputUnifierActivity", "UIL: Getting player input for player " + (player == null ? "0" : player.getPlayerNumber()));
		
		if (player == null)
		{ Log.i("UnityInputUnifierActivity", "no player for this event"); Log.i("UnityInputUnifierActivity", "no player for this event");return; } //no player corresponds to this controller

		if (e.action().equals(ControllerEvent.Action.ACTION_DOWN) || e.action().equals(ControllerEvent.Action.ACTION_UP))
		{
			boolean isDown = e.action().equals(ControllerEvent.Action.ACTION_DOWN);
			String direction = null;
			
			switch(e.cCode())
			{
			case LEFT_ANALOG_AS_DPAD_UP:
				direction = DIRECTION_LEFT_ANALOG_UP;
				break;
			case LEFT_ANALOG_AS_DPAD_RIGHT:
				direction = DIRECTION_LEFT_ANALOG_RIGHT;
				break;
			case LEFT_ANALOG_AS_DPAD_DOWN:
				direction = DIRECTION_LEFT_ANALOG_DOWN;
				break;
			case LEFT_ANALOG_AS_DPAD_LEFT:
				direction = DIRECTION_LEFT_ANALOG_LEFT;
				break;
				
			case RIGHT_ANALOG_AS_DPAD_UP:
				direction = DIRECTION_RIGHT_ANALOG_UP;
				break;
			case RIGHT_ANALOG_AS_DPAD_RIGHT:
				direction = DIRECTION_RIGHT_ANALOG_RIGHT;
				break;
			case RIGHT_ANALOG_AS_DPAD_DOWN:
				direction = DIRECTION_RIGHT_ANALOG_DOWN;
				break;
			case RIGHT_ANALOG_AS_DPAD_LEFT:
				direction = DIRECTION_RIGHT_ANALOG_LEFT;
				break;
			}
			
			if(direction != null)
			{
				ButtonAction(player, direction, isDown);
			}
		}
	}	

	private void controllerButtonEvent(ControllerEvent e)
	{
		//find the player that the event is meant for
		ControllerPlayer player = m_boundPlayerControllers.get(e.id());
		if (player == null)
		{ Log.i("UnityInputUnifierActivity", "no player for this event"); return; } //no player corresponds to this controller

		if (e.action().equals(ControllerEvent.Action.ACTION_DOWN) || e.action().equals(ControllerEvent.Action.ACTION_UP))
		{
			boolean isDown = e.action().equals(ControllerEvent.Action.ACTION_DOWN);
			String button = null;
			
			switch(e.cCode())
			{
			case A_BUTTON:
				button = BUTTON_A;
				break;
			case B_BUTTON:
				button = BUTTON_B;
				break;
			case X_BUTTON:
				button = BUTTON_X;
				break;
			case Y_BUTTON:
				button = BUTTON_Y;
				break;
			case L1_BUTTON:
				button = BUTTON_L1;
				break;
			case L2_BUTTON:
				button = BUTTON_L2;
				break;
			case L3_BUTTON:
				button = BUTTON_L3;
				break;
			case R1_BUTTON:
				button = BUTTON_R1;
				break;
			case R2_BUTTON:
				button = BUTTON_R2;
				break;
			case R3_BUTTON:
				button = BUTTON_R3;
				break;
			case BACK_BUTTON:
				button = BUTTON_BACK;
				break;
			case START_BUTTON:
				button = BUTTON_START;
				break;
			}

			if (button != null)
			{
				ButtonAction(player, button, isDown);
			}
		}
	}

	private void ButtonAction(ControllerPlayer player, String code, boolean press)
	{
		com.unity3d.player.UnityPlayer.UnitySendMessage(GAME_OBJECT_NAME,(press ? ButtonPress : ButtonRelease),Integer.toString(player.getPlayerNumber()) + code);		
	}
	
	private void AnalogEvent(ControllerPlayer player, String code, ControllerEvent e) {
		HashMap<AnalogDataType,Double> analogData = e.analogData();
		String params[] = { Integer.toString(player.getPlayerNumber()), code, analogData.get(ControllerEvent.AnalogDataType.X_DATA).toString(), 
				(analogData.containsKey(ControllerEvent.AnalogDataType.Y_DATA) ? analogData.get(ControllerEvent.AnalogDataType.Y_DATA).toString() : "")  };
		com.unity3d.player.UnityPlayer.UnitySendMessage(GAME_OBJECT_NAME,analogEvent, android.text.TextUtils.join(",", params));
	}
	
	private void ControllerAction(ControllerPlayer player, String code) {
		com.unity3d.player.UnityPlayer.UnitySendMessage(GAME_OBJECT_NAME,controllerEvent,Integer.toString(player.getPlayerNumber()) + code);
	}
	

	private static final String ButtonPress = "set_Button";
	private static final String ButtonRelease = "clear_Button";
	private static final String analogEvent = "analog_Event";
	private static final String controllerEvent = "controller_Event";

	
	private static final String DIRECTION_UP = "U";
	private static final String DIRECTION_RIGHT = "R";
	private static final String DIRECTION_DOWN = "D";
	private static final String DIRECTION_LEFT = "L";

	private static final String DIRECTION_LEFT_ANALOG_UP = "LAU";
	private static final String DIRECTION_LEFT_ANALOG_RIGHT = "LAR";
	private static final String DIRECTION_LEFT_ANALOG_DOWN = "LAD";
	private static final String DIRECTION_LEFT_ANALOG_LEFT = "LAL";

	private static final String DIRECTION_RIGHT_ANALOG_UP = "RAU";
	private static final String DIRECTION_RIGHT_ANALOG_RIGHT = "RAR";
	private static final String DIRECTION_RIGHT_ANALOG_DOWN = "RAD";
	private static final String DIRECTION_RIGHT_ANALOG_LEFT = "RAL";
	
	private static final String LEFT_ANALOG = "LA";
	private static final String RIGHT_ANALOG = "RA";
	private static final String L2_ANALOG = "L2A";
	private static final String R2_ANALOG = "R2A";
	
	private static final String BUTTON_A = "A";
	private static final String BUTTON_B = "B";
	private static final String BUTTON_X = "X";
	private static final String BUTTON_Y = "Y";
	
	private static final String BUTTON_BACK = "SEL";
	private static final String BUTTON_START = "ST";
	
	private static final String BUTTON_L1 = "L1";
	private static final String BUTTON_L2 = "L2";
	private static final String BUTTON_L3 = "L3";
	private static final String BUTTON_R1 = "R1";
	private static final String BUTTON_R2 = "R2";
	private static final String BUTTON_R3 = "R3";
	
	private static final String CONTROLLER_CONNECTED = "XC";
	private static final String CONTROLLER_DISCONNECTED = "XD";
	
	private HashMap<ControllerEvent.CommonCodes,ControllerEvent.CommonCodes> simpleCodeRemap = null;
	

	private void hideSystemUI()
	{
		// Ask the System Bar to hide
		try 
		{
			View mainLayout = getWindow().getDecorView().getRootView();
			mainLayout.setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION);
		} 
		catch (Exception ex) 
		{
			Log.i("UnityInputUnifierActivity", "We are not ICS");
		}

	}
	
	private void killAccelerometer()
	{
		SensorManager sm = (SensorManager)getSystemService(Context.SENSOR_SERVICE);
		if(sm != null)
		{
			//Log.i("UnityInputUnifierActivity", "FOund Sensor Manager");
			try
			{
				com.unity3d.player.UnityPlayer up = null;
				Field fields[] = UnityPlayerActivity.class.getDeclaredFields();
				int i;
				for(i = 0; i < fields.length; ++i)
				{
					if(fields[i].getType() == com.unity3d.player.UnityPlayer.class)
					{
						fields[i].setAccessible(true);
						up = (com.unity3d.player.UnityPlayer)fields[i].get(this);
						//fields[i].setAccessible(false);
						break;
					}
				}
				
				if(up != null)
				{
					//Log.i("UnityInputUnifierActivity", "Found Unity Player");
					SensorEventListener sel = null;
					fields = com.unity3d.player.UnityPlayer.class.getDeclaredFields();
					for(i = 0; i < fields.length; ++i)
					{
						//find SensorEventListener interface
						//Log.i("UnityInputUnifierActivity", "field " + fields[i].getName() + " class: " + fields[i].getType().getName());
						if(fields[i].getType().getName().equals("com.unity3d.player.p"))
						{
							fields[i].setAccessible(true);
							sel = (SensorEventListener)fields[i].get(up);
							break;
						}
					}
					
					if(sel != null)
					{
						//Log.i("UnityInputUnifierActivity", "Unregistering sensor listener");
						sm.unregisterListener(sel);
					}
				}
				
			}
			catch(Exception e)
			{
				Log.w("UnityInputUnifierActivity", "Exception during attempt to find sensor listener " + e.toString());
			}
		}
	}	
} // %%%%%% END CLASS %%%%%%%%